/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenReportAction.java,v 1.3 2008/01/24 02:29:09 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.uml2sd.ui.actions.widgets;

import org.eclipse.hyades.ui.internal.wizard.HyadesReportWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIImages;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * CONTEXT_ID owiz0000 for new wizard action
 */

public class OpenReportAction extends Action {
    protected IStructuredSelection selection;

    public OpenReportAction() {
        super(CommonUIMessages._148); //$NON-NLS-1$
		
		setText(CommonUIMessages._148);
		CommonUIImages.INSTANCE.setImageDescriptors(this, CommonUIImages.IMG_UI_REPORT);
		setDescription(CommonUIMessages._148);
		setToolTipText(CommonUIMessages._148);
    }

    public OpenReportAction(IStructuredSelection sel) {
    	
    	this();
    	
    	selection = sel;
    	
     }
    
    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        HyadesReportWizard wizard = new HyadesReportWizard();
        wizard.init(window.getWorkbench(), selection);

        WizardDialog dialog = new WizardDialog(window.getShell(), wizard);
        dialog.create();
        dialog.open();
        wizard.dispose();

//        selection = null;
    }

    public void selectionChanged(IStructuredSelection structuredSelection) {
        selection = structuredSelection;
    }

    public boolean isApplicableForSelection() {
        if (selection == null || selection.isEmpty()) return false;
        return true;
    }

}
