/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: PagesDialog.java,v 1.4 2008/01/24 02:29:09 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.widgets;


import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.util.ContextIDs;
import org.eclipse.hyades.uml2sd.util.SDMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

import com.ibm.icu.text.MessageFormat;

/**
 * This is the filters list dialog.<br>
 * It is associated to an SDView and to a ISDFilterProvider.<br> 
 */
public class PagesDialog extends Dialog {
	
	/**
	 * viewer and provided are kept here as attributes
	 */
	protected ISDAdvancedPagingProvider provider = null;
	protected TextArea currentPage/*, maxItemByPage*/;
	protected Label totalPageComment/*, totalItemComment*/;
	
	/**
	 * This is a Text Control that accepts only digits and ensures that bounds are respected
	 */
	protected class TextArea {
		
		protected Text text;
		int min, max;
		
		public TextArea(Composite parent) {
			text = new Text(parent, SWT.SINGLE | SWT.BORDER | SWT.RIGHT);
//			text.addVerifyListener(new VerifyListener() {
//				public void verifyText(VerifyEvent e) {
//					if (e.character == '\0' ||
//						Character.isDigit(e.character)) {
//						e.doit = true;
//					} else {
//						e.doit = false;
//					}
//				}});
			text.setTextLimit(10);
//			GridData data = new GridData();
//			data.widthHint = convertWidthInCharsToPixels(10);
//			text.setLayoutData(data);
		}
		
		public void setValue(int v) {
			int value = Math.max(min, Math.min(max, v));
			text.setText(Integer.toString(value));
		}
		
		public int getValue() {
			int res;
			try {
				res = Integer.parseInt(text.getText());
			} catch (Exception e) {
				// ignored
				res = 0;
			}
			return Math.max(min, Math.min(max, res));
		}
		
		public void setBounds(int min_, int max_) {
			min = Math.max(0, min_);
			max = Math.max(min, max_);
			Integer tab[] = new Integer[2];
			tab[0] = new Integer(min);
			tab[1] = new Integer(max);
			text.setToolTipText(MessageFormat.format(SDMessages._69, tab)); 
		}
	}
	
	/**
	 * 
	 */
	protected void updateComments() {
		int pages = Math.max(0, provider.pagesCount());
		String totalPageCommentText = SDMessages._70 + pages + " ";  //$NON-NLS-1$
		if (pages == 0) {
			totalPageCommentText += SDMessages._71; 
		} else if (pages == 1) {
			totalPageCommentText += SDMessages._72; 
		} else {
			totalPageCommentText += SDMessages._73; 
		}
		totalPageComment.setText(totalPageCommentText);

//		int items = Math.max(0, provider.itemsTotalCount());
//		String currentItemsCommentText = SDMessages.getString("_74") + items + " "; //$NON-NLS-1$ //$NON-NLS-2$
//		if (items == 0) {
//			currentItemsCommentText += provider.noItemsText();
//		} else if (items == 1) {
//			currentItemsCommentText += provider.oneItemText();
//		} else {
//			currentItemsCommentText += provider.itemsText();
//		}
//		totalItemComment.setText(currentItemsCommentText);
	}
	
	/**
	 * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	 */
	public Control createDialogArea(Composite parent) {
		
		Group ret = new Group(parent, SWT.NONE);
		PlatformUI.getWorkbench().getHelpSystem().setHelp(ret,"org.eclipse.hyades.ui"+ContextIDs.UML2SDPAGE);
		GridData data = new GridData();
		data.grabExcessHorizontalSpace = true;
		data.horizontalAlignment = GridData.FILL;
		ret.setLayoutData(data);
		ret.setText(SDMessages._67); 

		FillLayout fillLayout = new FillLayout(SWT.VERTICAL); 
		ret.setLayout(fillLayout);
		
		Label label = new Label(ret, SWT.NONE);
		label.setText(SDMessages._75); 
		
		currentPage = new TextArea(ret);
		currentPage.setBounds(1, provider.pagesCount());
		currentPage.setValue(provider.currentPage()+1);

		totalPageComment = new Label(ret, SWT.NONE);
		totalPageComment.setAlignment(SWT.RIGHT);

//		totalItemComment = new Label(ret, SWT.NONE);
//
//		Label label2 = new Label(ret, SWT.NONE);
//		String tab[] = new String[1];
//		tab[0] = provider.itemsText();
//		label2.setText(MessageFormat.format(SDMessages.getString("_76"), tab)); //$NON-NLS-1$
//
//		maxItemByPage = new TextArea(ret);
//		maxItemByPage.setBounds(100, 10*1000*1000);
//		maxItemByPage.setValue(provider.maxItemsByPageCount());

		updateComments();

		getShell().setText(SDMessages._68); 
		return ret;
	}
	
	/**
	 * @param view_
	 * @param loader_
	 */
	public PagesDialog(IViewPart view_, ISDAdvancedPagingProvider loader_) {
		super (view_.getSite().getShell());
		provider = loader_;
		setShellStyle(SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
	}
	
	/**
	 * Opens the dialog box
	 */
	public int open() {
		return super.open();
	}
	
	/**
	 * Called when the dialog box ok button is pressed
	 */
	public void okPressed()	{
		//int maxItemByPageValue = maxItemByPage.getValue();
		int currentPageValue = currentPage.getValue()-1;
		super.close();
		//provider.pageSettingsChanged(maxItemByPageValue, currentPageValue);
		provider.pageNumberChanged(currentPageValue);
	}
	
}

