/**********************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ITimeRange2.java,v 1.1 2007/03/15 00:14:20 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.uml2sd.ui.core;
/**
 * An interface added to synchronize the Log Interactions View time zone
 * with the Log View time zone for each LogGraphNode.
 * In general it can be used in any situations where date-time relative to a certain time zone is required for messages or execution occurrences. 
 * @author ldancy
 * @author apnan
 */
public interface ITimeRange2 extends ITimeRange 
{
	
	/**
	 * 
	 * @return Time zone offset to GMT in milliseconds
	 */
	public int getTimeZone();
	
	/**
	 * Sets the time zone offset to GMT in milliseconds
	 * @param zoneOffset
	 */
	public void setTimeZone(int zoneOffset);
}
