/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SDImages.java,v 1.2 2009/03/24 16:12:26 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.uml2sd.ui.internal;

import java.net.URL;

import org.eclipse.hyades.ui.internal.util.ImageManager;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

/**
 * <p>SD image manager.</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version March 24, 2009
 * @since   August 16, 2006
 */
public class SDImages extends ImageManager
{
	public static final SDImages INSTANCE = new SDImages();
	
	/**
	 * No-argument constructor.
	 */
	public SDImages(){
		
		try	{
			initialize(new URL(CommonUIPlugin.getDefault().getBundle().getEntry("/"), "icons/full/"), CommonUIPlugin.getDefault().getImageRegistry()); //$NON-NLS-1$ //$NON-NLS-2$
		}
		catch(Exception e) {
			CommonUIPlugin.log(e);
		}	
	}
	
	/* lcl16 */
	public static final String GOTO_PAGE				= "gotopage_menu.gif";
	public static final String NODE_START				= "node_end.gif";
	public static final String NODE_END					= "node_start.gif";
		
	protected void addImages() 
	{		
		/* lcl16 */
		add("c", T_LCL, GOTO_PAGE);
		add("c", T_LCL, NODE_START);
		add("c", T_LCL, NODE_END);					
	}
}
