/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: DebugUtil.java,v 1.2 2006/09/20 20:56:27 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.util;

import org.eclipse.core.runtime.Platform;

public class DebugUtil {
	
	public static boolean debugIndex()
	{
		if (debug())
		{
			if (Platform.getDebugOption("org.eclipse.hyades.ui/updateindex").//$NON-NLS-1$
				equalsIgnoreCase("true"))//$NON-NLS-1$
				return true;
		}
		return false;
	}
	
	public static boolean debugDisplay()
	{
		if (debug())
		{
			if (Platform.getDebugOption("org.eclipse.hyades.ui/display").//$NON-NLS-1$
				equalsIgnoreCase("true"))//$NON-NLS-1$
				return true;
		}
		return false;
	}
	
	public static boolean debugDoubleBuffer()
	{
		if (debug())
		{
			if (Platform.getDebugOption("org.eclipse.hyades.ui/doublebuffer").//$NON-NLS-1$
				equalsIgnoreCase("true"))//$NON-NLS-1$
				return true;
		}
		return false;
	}
	
	public static boolean debugSorting()
	{
		if (debug())
		{
			if (Platform.getDebugOption("org.eclipse.hyades.ui/sorting").//$NON-NLS-1$
				equalsIgnoreCase("true"))//$NON-NLS-1$
				return true;
		}
		return false;
	}
	
	public static boolean debug()
	{
		if (Platform.getDebugOption("org.eclipse.hyades.ui/debug")!=null) //$NON-NLS-1$
		{
			if (Platform.getDebugOption("org.eclipse.hyades.ui/debug").//$NON-NLS-1$
				equalsIgnoreCase("true")) //$NON-NLS-1$
				return true; 
		}
		return false;
	}


}
