/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MinMaxDialog.java,v 1.2 2008/01/24 02:28:51 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.util;

import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;


/**
 * @author sveyrier
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class MinMaxDialog extends Dialog {

	protected Label minLabel;

	protected Label maxLabel;
	
	protected Text minText;
	
	protected Text maxText;
	
	protected Combo unit1,unit2;
	
	SDWidget sdWidget;

	
	public MinMaxDialog(Shell s, SDWidget v) {
		super(s);
		sdWidget=v;
	}
	
	protected GridData newGridData(int span) {
		GridData data = new GridData(GridData.GRAB_VERTICAL
				| GridData.VERTICAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL
				| GridData.HORIZONTAL_ALIGN_FILL);
		data.horizontalSpan = span;
		return data;
	}

	protected Control createDialogArea(Composite p) {
		// TODO Auto-generated method stub
		p.getShell().setText(SDMessages._123); //$NON-NLS-1$
		Composite parent = (Composite) super.createDialogArea(p);

		GridLayout parentLayout = new GridLayout();
		parentLayout.numColumns = 6;
		parent.setLayout(parentLayout);

		Group g1 = new Group(parent, SWT.SHADOW_NONE);
		g1.setLayoutData(newGridData(3));
		GridLayout g1layout = new GridLayout();
		g1layout.numColumns = 3;
		g1.setLayout(g1layout);

		minLabel = new Label(g1, SWT.RADIO);
		minLabel.setText(SDMessages._124); //$NON-NLS-1$
		minLabel.setLayoutData(newGridData(1));

		minText = new Text(g1, SWT.SINGLE | SWT.BORDER);
		minText.setLayoutData(newGridData(1));
		minText.setText(TimeUtil.deltaToString(sdWidget.getFrame().getMinTime()));
		
		unit1 = new Combo(g1,SWT.READ_ONLY);
		unit1.add(TimeUtil.deltaNormalString[0],0);
		unit1.add(TimeUtil.deltaNormalString[1],1);
		unit1.add(TimeUtil.deltaNormalString[2],2);
		unit1.add(TimeUtil.deltaNormalString[3],3);
		unit1.add(TimeUtil.deltaNormalString[4],4);
		unit1.add(TimeUtil.deltaNormalString[5],5);
		unit1.select(TimeUtil.deltaUnit(sdWidget.getFrame().getMinTime()));
		
		maxLabel = new Label(g1, SWT.RADIO);
		maxLabel.setText(SDMessages._125); //$NON-NLS-1$
		maxLabel.setLayoutData(newGridData(1));

		maxText = new Text(g1, SWT.SINGLE | SWT.BORDER);
		maxText.setLayoutData(newGridData(1));
		maxText.setText(TimeUtil.deltaToString(sdWidget.getFrame().getMaxTime()));
		
		unit2 = new Combo(g1,SWT.READ_ONLY);
		unit2.add(TimeUtil.deltaNormalString[0],0);
		unit2.add(TimeUtil.deltaNormalString[1],1);
		unit2.add(TimeUtil.deltaNormalString[2],2);
		unit2.add(TimeUtil.deltaNormalString[3],3);
		unit2.add(TimeUtil.deltaNormalString[4],4);
		unit2.add(TimeUtil.deltaNormalString[5],5);
		unit2.select(TimeUtil.deltaUnit(sdWidget.getFrame().getMaxTime()));
		
		return parent;
	}
	
	protected double applyUnit(double value, Combo unit)
	{
		switch (unit.getSelectionIndex()) 
		{
			case 0:
			{
				return value*24*60*60;
			}	
			case 1:
			{
				return value*60*60;
			}
			case 2:
			{
				return value*60;
			}
			case 3:
			{
				return value;
			}
			case 4:
			{
				return value/1000;
			}
			default:
			{
				return value/1000000;
			}
		}
	}
	
	protected void okPressed() {
		double min=0;
		double max=0;
		try
		{
			
			min=Double.parseDouble(minText.getText());
			max=Double.parseDouble(maxText.getText());
			sdWidget.getFrame().setMax(applyUnit(max,unit2));
			sdWidget.getFrame().setMin(applyUnit(min,unit1));
			sdWidget.redraw();
		super.okPressed();
		}
		catch (Exception e)
		{
			MessageDialog.openError(getShell(),
					SDMessages._98, //$NON-NLS-1$
					SDMessages._99); //$NON-NLS-1$
		}
	}

	protected void createButtonsForButtonBar(Composite parent)
	{
		super.createButtonsForButtonBar(parent);
		createButton(parent, IDialogConstants.CLIENT_ID,
				SDMessages._126, false);  //$NON-NLS-1$
		getButton(IDialogConstants.CLIENT_ID).addSelectionListener(new SelectionListener(){

			public void widgetSelected(SelectionEvent e) {
				sdWidget.getFrame().resetCustomMinMax();
				minText.setText(TimeUtil.deltaToString(sdWidget.getFrame().getMinTime()));
				maxText.setText(TimeUtil.deltaToString(sdWidget.getFrame().getMaxTime()));
				unit1.select(TimeUtil.deltaUnit(sdWidget.getFrame().getMinTime()));
				unit2.select(TimeUtil.deltaUnit(sdWidget.getFrame().getMaxTime()));
				maxText.getParent().layout(true);
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				
			}
			
		});
	}
}
