/********************************************************************** 
 * Copyright (c) 2005, 2008  IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: SDPrintDialog.java,v 1.3 2008/01/24 02:28:52 apnan Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/

package org.eclipse.hyades.uml2sd.util;

import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;


/**
 * @author sveyrier
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class SDPrintDialog extends Dialog {

	protected SDWidget view;

	protected SDPrintDialogUI dialogUI;

	protected String errorMessage = null;
	protected Label messageLabel = null;
	protected boolean isPageComplete = true;

	public SDPrintDialog(Shell s, SDWidget v) {
		super(s);
		view = v;
		
		dialogUI = new SDPrintDialogUI(s, view);		
		dialogUI.setParentDialog(this);
	}

	protected Control createDialogArea(Composite p) {
		// TODO Auto-generated method stub
		p.getShell().setText(SDMessages._114); //$NON-NLS-1$
		Composite parent = (Composite) super.createDialogArea(p);
		
		dialogUI.createDialogArea(parent);

		// bug 195026
		messageLabel = new Label(parent, SWT.NONE);
		GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
		gridData.horizontalSpan = 6;
		messageLabel.setLayoutData(gridData);
		setErrorMessage(errorMessage);

		return parent;
	}



	protected void okPressed() {
		
		if(dialogUI.okPressed())
			super.okPressed();
	}


	protected void createButtonsForButtonBar(Composite parent)
	{
		
		super.createButtonsForButtonBar(parent);
		createButton(parent, IDialogConstants.CLIENT_ID,
				SDMessages._115, false);  //$NON-NLS-1$
		
		getButton(IDialogConstants.CLIENT_ID).addSelectionListener(new SelectionListener(){

			public void widgetSelected(SelectionEvent e) {
				
				dialogUI.printButtonSelected();
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
			
		});

		updateButtons();
	}

	public SDPrintDialogUI getDialogUI() {
		return dialogUI;
	}

	public void setErrorMessage(String message) {
		errorMessage = message;
		if (messageLabel != null) {
			if (errorMessage == null) {
				messageLabel.setText(""); //$NON-NLS-1$
			} else {
				messageLabel.setText(errorMessage);
			}
		}
	}

	public void setPageComplete(boolean complete) {
		isPageComplete = complete;
		updateButtons();
	}

	public void updateButtons() {
		Button okButton = getButton(IDialogConstants.OK_ID);
		if (isPageComplete) {
			if (okButton != null) {
				okButton.setEnabled(true);
			}
		} else {
			if (okButton != null) {
				okButton.setEnabled(false);
			}
		}
	}

}
