/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SDUtil.java,v 1.4 2008/01/24 02:28:52 apnan Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/


/*
 * Created on Jan 25, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.eclipse.hyades.uml2sd.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.load.LoadersManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIConstants;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;

public class SDUtil {
	
	protected static SDUtil instance;
	
	public static final String LOADER_TAG = "uml2SDLoader"; //$NON-NLS-1$
	public static final String LOADER_PREFIX = LOADER_TAG+"."; //$NON-NLS-1$
	protected static HashMap viewLoadersList = new HashMap();

	
	protected static URL BASIC_URL=null;

	static
	{
		//URL to get images from plugins
		//perhaps we can found better code to load images ...
		//but at this time I know this: 
		try {
		BASIC_URL = new URL( "platform", "localhost", "plugin");//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch( Exception E ) {
			System.err.println(E);
		}
	}
	
	public SDUtil()
	{
		if(instance == null)
			instance = this;
	}

	public static ImageDescriptor getResourceImage( String _name )
	{
		try {
		 URL url=new URL( BASIC_URL, "plugin/org.eclipse.hyades.ui/icons/"+_name);//$NON-NLS-1$
		 ImageDescriptor img = ImageDescriptor.createFromURL( url );
		return img ;
		} catch( Exception E ) {
					 System.err.println(E);
		}
		return null;
	}
	

	public static List getLoaders(String viewId) {
		List list = (List)viewLoadersList.get(viewId);
		if (list != null) {
			return list;
		}
		ArrayList ret = new ArrayList();
		IExtensionPoint iep = Platform.getExtensionRegistry().getExtensionPoint(CommonUIPlugin.PLUGIN_ID, LOADER_TAG);
		IExtension[] commonUIExtensions = iep.getExtensions();
		
		/* Ali M.: For backward compatibility */
		IExtension[] ie = null;
		iep = Platform.getExtensionRegistry().getExtensionPoint(CommonUIConstants.HYADES_UI_PLUGIN_ID, LOADER_TAG);
		if (iep != null)
		{
			IExtension[] hyadesUIExtensions = iep.getExtensions();
			if (hyadesUIExtensions != null && hyadesUIExtensions.length > 0)
			{
				ie = new IExtension[commonUIExtensions.length + hyadesUIExtensions.length];
				System.arraycopy(commonUIExtensions, 0, ie, 0, commonUIExtensions.length);
				System.arraycopy(hyadesUIExtensions, 0, ie, commonUIExtensions.length, hyadesUIExtensions.length);
			}
		}
		if (ie == null)
			ie = commonUIExtensions;
		
		
		for (int i = 0; i < ie.length; i++) {
			IConfigurationElement c[] = ie[i].getConfigurationElements();
			for (int j = 0; j < c.length; j++) {
				if (viewId.equals(c[j].getAttribute("view"))) { //$NON-NLS-1$
					ret.add(c[j]);
				}
			}
		}
		viewLoadersList.put(viewId, ret);
		return ret;
	}
	
	/**
	 * @param viewId
	 * @param ce
	 */
	public static void createLoaderForView(String viewId, IConfigurationElement ce) {
		try {
			Object obj = ce.createExecutableExtension("class"); //$NON-NLS-1$
			IUml2SDLoader l = (IUml2SDLoader) obj;
			if (viewId != null)
				LoadersManager.getLoadersManager().setCurrentLoader(l, viewId); //$NON-NLS-1$
		} catch (CoreException e4) {
			System.err.println("Error 'uml2SDLoader' Extension point :" + e4); //$NON-NLS-1$
		} catch (Exception e5) {
			e5.printStackTrace();
			System.err.println("Error 'uml2SDLoader' Extension point :" + e5); //$NON-NLS-1$
		}
	}

	
	/**
	 * Returns the loader class name that have been saved last time
	 * @param viewId the view this loader belongs to
	 * @return the class name of the saved loader
	 */
	public String getSavedLoader(String viewId) {
		Preferences p = CommonUIPlugin.getDefault().getPluginPreferences();
		return p.getString(LOADER_PREFIX+viewId);
	}
	
	/**
	 * Saves the last loader in order to reload it on next session.
	 */
	public void setLastLoader(String id,String id2) {
		Preferences p = CommonUIPlugin.getDefault().getPluginPreferences();
		p.setValue(LOADER_PREFIX+id2, id);
	}
	
	/**
	 * @return Returns the instance.
	 */
	public static SDUtil getInstance() {
		
		if(instance == null)
			instance = new SDUtil();
		
		return instance;
	}
}
