/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TimeEventComparator.java,v 1.2 2006/09/20 20:56:27 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.util;

import java.util.Comparator;

import org.eclipse.hyades.uml2sd.ui.core.TimeEvent;

/**
 * Time event comparator
 * 
 * @author sveyrier
 *
 */
public class TimeEventComparator implements Comparator{
	

	/**
	 * Compares two time events
	 * Returns 0 (equal) if one of args is not a time event
	 * @return 1 if arg0 is greater, 0 if equal, -1 otherwise
	 */
	public int compare(Object arg0, Object arg1) {
	if (arg0 instanceof TimeEvent && arg1 instanceof TimeEvent)
	{
		TimeEvent t1 = (TimeEvent)arg0;
		TimeEvent t2 = (TimeEvent)arg1;
		if (t1.getEvent()>t2.getEvent())
			return 1;
		else if (t1.getEvent() == t2.getEvent())
			return 0;
		else return -1;
	}
	else return 0;
}

}
