/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TimeUtil.java,v 1.2 2008/01/24 02:28:52 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.util;

import com.ibm.icu.text.MessageFormat;

public class TimeUtil {
		
	protected static String normalStrings[] = {
		SDMessages._8, 
		SDMessages._6, 
		SDMessages._10, 
		SDMessages._12, 
		SDMessages._14, 
		SDMessages._16, 
		SDMessages._18
	};

	protected static String accessibleStrings[] = {
		SDMessages._9, 
		SDMessages._7, 
		SDMessages._11, 
		SDMessages._13, 
		SDMessages._15, 
		SDMessages._17, 
		SDMessages._19
	};
	
	public static String deltaNormalString[] = {
		SDMessages._128, 
		SDMessages._129, 
		SDMessages._130, 
		SDMessages._131, 
		SDMessages._132, 
		SDMessages._133 
	};

	/**
	 * Translate the given item into a localised string.
	 * @param time the time to translate
	 * @return the localised string
	 */
	public static String timeToString(double time) {
		return timeToString(time, normalStrings);
	}
	
	/**
	 * Translate the given item into an accessible localised string.
	 * @param time - the time to translate
	 * @return the localised string
	 */
	public static String accessibleTimeToString(double time) {
		return timeToString(time, accessibleStrings);
	}

	protected static String timeToString(double time, String ress[]) {
		String ret;
		if (Math.abs(time) >= 24*60*60) {
			int days, hours;
			days = (int)(time / (24*60*60));
			hours = Math.abs((int)(time % (24*60*60))/(60*60));
			if ((days != 1)&&(days != -1)) {
				ret = MessageFormat.format(ress[0],
										   new Object[] { new Integer(days), new Integer(hours) } );
			} else {
				ret = MessageFormat.format(ress[1],
										   new Object[] { new Integer(days), new Integer(hours) } );
			}
		} else if (Math.abs(time) >= 60*60) {
			int hours, mins;
			hours = (int)(time / (60*60));
			mins = Math.abs((int)(time % (60*60))/(60));
			ret = MessageFormat.format(ress[2],
									   new Object[] { new Integer(hours), new Integer(mins) } );
		} else if (Math.abs(time) >= 60) {
			int mins, s;
			mins = (int)(time / 60);
			s = Math.abs((int)(time % 60));
			ret = MessageFormat.format(ress[3],
								 	   new Object[] { new Integer(mins), new Integer(s) } );
		} else if (Math.abs(time) >= 1) {
			ret = MessageFormat.format(ress[4],
								 	   new Object[] { new Double(time) } );
		} else if (Math.abs(time*1000) >= 1){
			ret = MessageFormat.format(ress[5],
									   new Object[] { new Double(time*1000) } );
		} else {
			ret = MessageFormat.format(ress[6],
									   new Object[] { new Double(time*1000000) } );
		}
		return ret;
	}
	
	public static String deltaToString(double time) {
		if (Math.abs(time) >= 24*60*60) {
			int days;
			days = (int)(time / (24*60*60));
			return MessageFormat.format(SDMessages._127,new Object[] { new Integer(days)});
		} else if (Math.abs(time) >= 60*60) {
			int hours;
			hours = (int)(time / (60*60));
			return MessageFormat.format(SDMessages._127,new Object[] { new Integer(hours)});
		} else if (Math.abs(time) >= 60) {
			int mins;
			mins = (int)(time / 60);
			return MessageFormat.format(SDMessages._127,new Object[] { new Integer(mins)});
		} else if (Math.abs(time) >= 1) {
			return MessageFormat.format(SDMessages._127,new Object[] { new Double(time)});
		} else if (Math.abs(time*1000) >= 1){
			return MessageFormat.format(SDMessages._127,new Object[] { new Double(time*1000)});
		} else {
			return MessageFormat.format(SDMessages._127,new Object[] { new Double(time*1000000)});
		}
	}
	
	public static int deltaUnit(double time) {
		if (Math.abs(time) >= 24*60*60) {
			return 0;
		} else if (Math.abs(time) >= 60*60) {
			return 1;
		} else if (Math.abs(time) >= 60) {
			return 2;
		} else if (Math.abs(time) >= 1) {
			return 3;
		} else if (Math.abs(time*1000) >= 1){
			return 4;
		} else {
			return 5;
		}
	}

}
