/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: testLoaders.java,v 1.3 2008/01/24 02:29:02 apnan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ztest;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.core.AsyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.LifelineCategories;
import org.eclipse.hyades.uml2sd.ui.core.Stop;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.core.internal.EllipsisisMessage;
import org.eclipse.hyades.uml2sd.ui.core.internal.HotSpot;
import org.eclipse.hyades.uml2sd.ui.drawings.impl.ImageImpl;
import org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

/**
 * @author sveyrier
 *
 */
public class testLoaders implements IUml2SDLoader,ISDFindProvider,ISDFilterProvider,ISDPagingProvider,
				ISelectionListener{

	public SDView v;
	
	public int page =1;

	public testLoaders()
	{
	}
	
	public void setViewer(SDView  j)
	{
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService()
		.addPostSelectionListener(this);
		v = j;
		final Frame testFrame = new Frame();
		testFrame.setName("Sequence Diagram"); //$NON-NLS-1$
		LifelineCategories[] tt;
		tt=new LifelineCategories[2];
		tt[0]=new LifelineCategories();
		tt[1]=new LifelineCategories();
		tt[1].setName("Categorie 1"); //$NON-NLS-1$
//		TODO ZREFACTOR change image access
		tt[0].setImage(new ImageImpl("full/obj16/copy_r_obj.gif")); //$NON-NLS-1$
//		TODO ZREFACTOR change image access
//		tt[1].setImage(new ImageImpl("big.gif2")); //$NON-NLS-1$
		tt[0].setName("Categorie 0"); //$NON-NLS-1$
		testFrame.setLifelineCategories(tt);
		Lifeline lifeline=new Lifeline();
		lifeline.setName("LifeLine " + 0); //$NON-NLS-1$
		testFrame.addLifeLine(lifeline);
//		SyncMessage mn = new SyncMessage();
		EllipsisisMessage mn = new EllipsisisMessage();
		lifeline.getNewEventOccurrence();
		mn.setStartLifeline(lifeline);
		mn.setName("*******************TEST ****************"); //$NON-NLS-1$
		testFrame.addMessage(mn);
		
		SyncMessage mn3 = new SyncMessage();
		mn3.setStartLifeline(lifeline);
//		mn.setName("*******************TEST ****************"); //$NON-NLS-1$
		testFrame.addMessage(mn3);
		
		SyncMessage mn2 = new SyncMessage();
		lifeline.getNewEventOccurrence();
		lifeline.setCategory(0);
		mn2.setEndLifeline(lifeline);
		testFrame.setTimeUnitName("Toto"); //$NON-NLS-1$
		mn2.setName("*******************TEST ****************"); //$NON-NLS-1$
		testFrame.addMessage(mn2);
//		testFrame.forceEventOccurrenceSpacing(15);
		for (int i=1;i<300;i++)
		{
			lifeline=new Lifeline();
			lifeline.setName("LifeLine " + i); //$NON-NLS-1$
			lifeline.setCategory(1);
			testFrame.addLifeLine(lifeline);

			SyncMessage m3= new SyncMessage();
			testFrame.getLifeline(i-1).getNewEventOccurrence();
			m3.setStartLifeline(testFrame.getLifeline(i-1));
			m3.setEndLifeline(testFrame.getLifeline(i));
			m3.setName("Message "+i); //$NON-NLS-1$
			testFrame.addMessage(m3);
			if (i==11)
			m3.setTime(i-400);///34.8);
			else if (i==6)
				m3.setTime(i);
			else m3.setTime(i+1);
		
		}
		for (int i=testFrame.lifeLinesCount()-1; i > 0; i--)
		{
			SyncMessageReturn m = new SyncMessageReturn();
			testFrame.getLifeline(i).getNewEventOccurrence();
			m.setStartLifeline(testFrame.getLifeline(i));
			m.setEndLifeline(testFrame.getLifeline(i-1));
			testFrame.addMessage(m);
			m.setName("Message return "+i); //$NON-NLS-1$
			if (i+1<testFrame.lifeLinesCount())
			{
				SyncMessage h=testFrame.getSyncMessage(i+1);
				m.setMessage(h);
			}
		}
		for (int i=0;i<testFrame.lifeLinesCount();i++)
		{
			if (i>0)
			{
				ExecutionOccurrence occ= new ExecutionOccurrence();
				occ.setStartOccurrence(testFrame.getSyncMessage(i).getEventOccurrence()+1);
				occ.setEndOccurrence(testFrame.getSyncMessageReturn(testFrame.syncMessageReturnCount()-i).getEventOccurrence());
				testFrame.getLifeline(i).addExecution(occ);
				occ.setName("*******************TEST ****************"); //$NON-NLS-1$
//				if (i==4)
//				occ.setColor(50,50,50);
			}
		}
	
		Stop s = new Stop();
		s.setLifeline(testFrame.getLifeline(1));
		s.setEventOccurrence(testFrame.getLifeline(1).getNewEventOccurrence());
		testFrame.getLifeline(1).addNode(s);
		
		HotSpot gg=new HotSpot();
		gg.setImage(new ImageImpl("full/obj16/plus_obj.gif")); //$NON-NLS-1$
		gg.setExecution((BasicExecutionOccurrence)(testFrame.getLifeline(1).getExecutions().get(0)));
	
		AsyncMessageReturn m = new AsyncMessageReturn();
		m.setStartLifeline(testFrame.getLifeline(1));
		m.setEndLifeline(testFrame.getLifeline(3));
		m.setStartOccurrence(6);
		m.setEndOccurrence(2);
		m.setStartTime(20);
		m.setEndTime(40);
		m.setName("*******************TEST ****************"); //$NON-NLS-1$
		testFrame.addMessage(m);
	
/*		SyncMessageReturn ma = new SyncMessageReturn();
		testFrame.getLifeline(2).getNewEventOccurrence();
		ma.setStartLifeline(testFrame.getLifeline(2));
		testFrame.getLifeline(2).getNewEventOccurrence();
		ma.setEndLifeline(testFrame.getLifeline(2));
		ma.setName("toto23frefrefrfrefrfe");
		testFrame.addMessage(ma);*/
		v.setFrame(testFrame);
		v.getSDWidget().setReorderMode(true);
	}

	public boolean hasNextPage() 
	{	
		if (page==1)
			return true;
		else return false;
	}

	public boolean hasPrevPage() 
	{
		if (page==2)
			return true;
		else return false;
	}
	
	public void prevPage()
	{
		page=1;
		setViewer(v);
	}

	public void nextPage()
	{
		page =2;
		final Frame testFrame = new Frame();
		testFrame.setName("Sequence Diagram"); //$NON-NLS-1$
		
		Lifeline lifeline=new Lifeline();
		lifeline.setName("LifeLine " + 0); //$NON-NLS-1$
		testFrame.addLifeLine(lifeline);
		lifeline=new Lifeline(); 
		lifeline.setName("LifeLine " + 1); //$NON-NLS-1$
		testFrame.addLifeLine(lifeline);
		for (int i=1;i<30;i++)
		{

			SyncMessage m3 = new SyncMessage();
			m3.autoSetStartLifeline(testFrame.getLifeline(0));
			m3.autoSetEndLifeline(testFrame.getLifeline(0));
			m3.setName("Message "+i); //$NON-NLS-1$
			testFrame.addMessage(m3);
//			m3.setTime(i+1);
		
			SyncMessageReturn m = new SyncMessageReturn();
			m.autoSetStartLifeline(testFrame.getLifeline(0));
			m.autoSetEndLifeline(testFrame.getLifeline(0));
			testFrame.addMessage(m);
//			m.setTime(i+1);
			m.setName("Message return "+i); //$NON-NLS-1$
			
/*			Stop s = new Stop();
			s.setLifeline(testFrame.getLifeline(0));
			s.setEventOccurrence(testFrame.getLifeline(0).getNewEventOccurrence());
			testFrame.getLifeline(0).addNode(s);*/
			
			ExecutionOccurrence occ= new ExecutionOccurrence();
			occ.setStartOccurrence(testFrame.getSyncMessage(i-1).getEventOccurrence());
			occ.setEndOccurrence(testFrame.getSyncMessageReturn(i-1).getEventOccurrence());
			testFrame.getLifeline(0).addExecution(occ);
/*			lifeline=new Lifeline(); 
			Lifeline h=testFrame.getLifeline(i);
			lifeline.setCurrentEventOccurrence(h.getEventOccurrence());
			lifeline.setName("LifeLine " + i+"\n"+"DGGDDDD");
			testFrame.addLifeLine(lifeline);
			ExecutionOccurrence occ= new ExecutionOccurrence();
			occ.setStartOccurrence(lifeline.getNewEventOccurrence());
			occ.setEndOccurrence(lifeline.getNewEventOccurrence());
			lifeline.addExecution(occ);*/
		}
		
		
		v.setFrame(testFrame);
	}
	
	public boolean find (Criteria toSearch)
	{
		return false;
	}
	
	/**
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFindProvider#cancel()
	 */
	public void cancel() {
		// Nothing to do
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.ui.actions.ISDProvider#getType()
	 */
	public LifelineCategories[] getCategories() {
		LifelineCategories[] t = new LifelineCategories[1];
	 	t[0]=new LifelineCategories();
	 	t[0].setName("Tab2"); //$NON-NLS-1$
//		t[1]=new LifelineCategories();
//		t[1].setName("Tab2");
	 	return t;
	}

	public boolean isLifelineSupported() {
		return false;
	}

	public boolean isSyncMessageSupported() {
		return false;
	}

	public boolean isSyncMessageReturnSupported() {
		return false;
	}

	public boolean isAsyncMessageSupported() {
		return false;
	}

	public boolean isAsyncMessageReturnSupported() {
		return false;
	}

	public boolean isStopSupported() {
		return false;
	}
	
	protected static URL BASIC_URL=null;
	static
	{
		//URL to get images from plugins
		//perhaps we can found better code to load images ...
		//but at this time I know this: 
		try {
		BASIC_URL = new URL( "platform", "localhost", "plugin");//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch( Exception E ) {
			System.err.println(E);
		}
	}
	   
	public Image getResourceImage( String _name )
	{
		try {
		 URL url=new URL( BASIC_URL, "plugin/org.eclipse.hyades.ui/icons/"+ _name);//$NON-NLS-1$
		 ImageDescriptor img = ImageDescriptor.createFromURL( url );
		return img.createImage() ;
		} catch( Exception E ) {
					 System.err.println(E);
				 }
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.IExtendedFindProvider#getFindAction()
	 */
	public Action getFindAction() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider#filter(java.util.ArrayList)
	 */
	public boolean filter(List filters) {
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFilterProvider#getCurrentFilters()
	 */
	public ArrayList getCurrentFilters() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#getTitleString()
	 */
	public String getTitleString() {
		// TODO Auto-generated method stub
		return "Test";//$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.load.IUml2SDLoader#aboutToBeReplaced()
	 */
	public void aboutToBeReplaced() {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.ISelectionListener#selectionChanged(org.eclipse.ui.IWorkbenchPart, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IWorkbenchPart part, ISelection selection) {
		ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService()
		.getSelection();
			if ((sel!=null)&&(sel instanceof StructuredSelection))
			{
			StructuredSelection stSel=(StructuredSelection)sel;
			if (stSel.getFirstElement() instanceof HotSpot)
			{
				OpenToolBox gg= new OpenToolBox(v);
				gg.run();
			}
			}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDGraphNodeSupporter#isNodeSupported(int)
	 */
	public boolean isNodeSupported(int nodeType) {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.uml2sd.ui.actions.provider.ISDGraphNodeSupporter#getNodeName(int)
	 */
	public String getNodeName(int nodeType, String loaderClassName) {
		// TODO Auto-generated method stub
		return null;
	}
}
