/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: CommonUIImages.java,v 1.6 2010/05/05 12:32:31 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.common.ui.internal;

import java.net.URL;

import org.eclipse.hyades.ui.internal.util.ImageManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;

/**
 * <p>Common UI image manager.</p>
 * 
 * 
 * @author  Ali Mehregani
 * @author  Paul Slauenwhite
 * @version May 4, 2010
 * @since   August 16, 2006
 */
public class CommonUIImages extends ImageManager
{
	public static final CommonUIImages INSTANCE = new CommonUIImages();
		
	/**
	 * No-argument constructor.
	 */
	public CommonUIImages(){
		
		try	{
			initialize(new URL(CommonUIPlugin.getDefault().getBundle().getEntry("/"), "icons/full/"), CommonUIPlugin.getDefault().getImageRegistry()); //$NON-NLS-1$ //$NON-NLS-2$
		}
		catch(Exception e) {
			CommonUIPlugin.log(e);
		}	
	}
	
	/* obj16 */
	public static final String IMG_UI_VIEW_FILTER_OBJ	= "view_filter_obj.gif";	//$NON-NLS-1$		
	public static final String IMG_UI_ZOOM				= "zoom_obj.bmp";			//$NON-NLS-1$
	public static final String IMG_UI_ZOOM_IN			= "zoomin_obj.bmp";			//$NON-NLS-1$
	public static final String IMG_UI_ZOOM_OUT			= "zoomout_obj.bmp";		//$NON-NLS-1$
	public static final String IMG_UI_HIDE_IMAGE		= "hide_image_maplist.gif";	//$NON-NLS-1$
	public static final String IMG_UI_SHOW_IMAGE		= "show_image_maplist.gif";	//$NON-NLS-1$
	
	/* lcl16 */
	public static final String IMG_LINK_WITH_VIEWER     = "synced.gif";			//$NON-NLS-1$
	public static final String IMG_IMPORT_RESOURCE 		= "import_wiz.gif";		//$NON-NLS-1$
	public static final String IMG_EXPORT_RESOURCE	 	= "export_wiz.gif";		//$NON-NLS-1$
	public static final String IMG_UI_VIEW_FILTER  		= "view_filter.gif";	//$NON-NLS-1$
	public static final String IMG_UI_HOME_MENU 		= "home_menu.gif";		//$NON-NLS-1$
	public static final String IMG_UI_SELECT_MENU 		= "select_menu.gif";	//$NON-NLS-1$
	public static final String IMG_UI_ZOOM_IN_MENU		= "zoomin_menu.gif";	//$NON-NLS-1$
	public static final String IMG_UI_ZOOM_OUT_MENU		= "zoomout_menu.gif";	//$NON-NLS-1$
	public static final String IMG_UI_FILTERS	 		= "filters.gif";			//$NON-NLS-1$
	public static final String IMG_UI_SEARCH_SEQ 		= "search_seqdiag_menu.gif";//$NON-NLS-1$
	public static final String IMG_UI_NEXT_PAGE 		= "next_menu.gif";		//$NON-NLS-1$
	public static final String IMG_UI_PREV_PAGE 		= "prev_menu.gif";		//$NON-NLS-1$
	public static final String IMG_UI_REPORT	 		= "report.gif";		//$NON-NLS-1$
	
	/* tool16 */
	public static final String NEW_WIZARD 				= "new_wiz.gif"; //$NON-NLS-1$    
	public static final String NEW_FOLDER_WIZARD 		= "newfolder_wiz.gif"; //$NON-NLS-1$    

	/* wizban */
	public static final String IMG_WZ_FILTER    		= "filter_wiz.gif";
	
	/* over16 */
	public static final String IMG_ERROR_DECORATOR = "error_ovr.gif";
	public static final String IMG_WARNING_DECORATOR = "warning_ovr.gif";
	
	
	protected void addImages() 
	{	
		/* obj16 */
		add(T_OBJ, IMG_UI_VIEW_FILTER_OBJ);
		add(T_OBJ, IMG_UI_ZOOM);
		add(T_OBJ, IMG_UI_ZOOM_IN);
		add(T_OBJ, IMG_UI_ZOOM_OUT);
		add(T_OBJ, IMG_UI_HIDE_IMAGE);
		add(T_OBJ, IMG_UI_SHOW_IMAGE);
		
		/* lcl16 */
		add("c", T_LCL, IMG_LINK_WITH_VIEWER);
		add("d", T_LCL, IMG_LINK_WITH_VIEWER);
		add("e", T_LCL, IMG_LINK_WITH_VIEWER);
		
		
		add("c", T_LCL, IMG_IMPORT_RESOURCE);
		add("d", T_LCL, IMG_IMPORT_RESOURCE);
		add("e", T_LCL, IMG_IMPORT_RESOURCE);
				
		add("c", T_LCL, IMG_EXPORT_RESOURCE);
		add("d", T_LCL, IMG_EXPORT_RESOURCE);
		add("e", T_LCL, IMG_EXPORT_RESOURCE);
		
        add("c", T_LCL, IMG_UI_VIEW_FILTER);
        add("d", T_LCL, IMG_UI_VIEW_FILTER);
        add("e", T_LCL, IMG_UI_VIEW_FILTER);
        
        add("c", T_LCL, IMG_UI_HOME_MENU);
        add("c", T_LCL, IMG_UI_SELECT_MENU);
        add("c", T_LCL, IMG_UI_ZOOM_IN_MENU);
        add("c", T_LCL, IMG_UI_ZOOM_OUT_MENU);
        add("c", T_LCL, IMG_UI_FILTERS);
        add("c", T_LCL, IMG_UI_SEARCH_SEQ);
        add("c", T_LCL, IMG_UI_NEXT_PAGE);
        add("c", T_LCL, IMG_UI_PREV_PAGE);

        add("c", T_LCL, IMG_UI_REPORT);
        add("d", T_LCL, IMG_UI_REPORT);
        add("e", T_LCL, IMG_UI_REPORT);        
        
        /* tool16 */
        add("e", T_TOOL, NEW_WIZARD); //$NON-NLS-1$
        add("d", T_TOOL, NEW_WIZARD); //$NON-NLS-1$
        
        add("e", T_TOOL, NEW_FOLDER_WIZARD); //$NON-NLS-1$
        add("d", T_TOOL, NEW_FOLDER_WIZARD); //$NON-NLS-1$
            	
        /* wizban */
        add(T_WIZBAN, IMG_WZ_FILTER);
        
        /* ovr16 */
		add(T_OVR,IMG_ERROR_DECORATOR);
		add(T_OVR,IMG_WARNING_DECORATOR);
        
	}
	
	public static void setActionImage(ImageManager instance, IAction action, String relPath) 
	{
		ImageDescriptor imageDesc = instance.getImageDescriptor("d", relPath);
		if (imageDesc != null)
		{
			action.setDisabledImageDescriptor(imageDesc);
		}

		
		imageDesc = instance.getImageDescriptor("c", relPath);
		if (imageDesc != null)
		{	
			action.setHoverImageDescriptor(imageDesc);
		}
		
		action.setImageDescriptor(instance.getImageDescriptor("e", relPath)); //$NON-NLS-1$
	}	
}
