/**********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.common.ui.internal.util;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIMessages;

public class PasswordDialog extends Dialog {
	
	protected String _title;
	protected Text _username;
	protected Text _password;
	protected String _url;
	protected ImportPasswordAuthentication _authentication;

	public PasswordDialog(Shell shell, String windowTitle, Image windowImage, String url, ImportPasswordAuthentication authentication) {
		super(shell);
		_title = windowTitle;
		_authentication = authentication;
		_url = url;
		setDefaultImage(windowImage);
	}
	
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(_title);
	}

	protected Control createDialogArea(Composite parent) {
		
		Composite result = (Composite) super.createDialogArea(parent);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		result.setLayout(layout);
		
		Label label = new Label(result, SWT.WRAP);
		label.setText(NLS.bind(CommonUIMessages.authMsg, _url));
		GridData data = new GridData(GridData.FILL);
		data.horizontalSpan = 2;
		data.minimumWidth = 400;
		label.setLayoutData(data);
		
		label = new Label(result, SWT.NONE);
		data = new GridData(GridData.FILL_HORIZONTAL);
		data.horizontalSpan = 2;
		label.setLayoutData(data);
			
		label = new Label(result, SWT.NONE);
		label.setText(CommonUIMessages._58);
		_username = new Text(result, SWT.BORDER);
		_username.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

		label = new Label(result, SWT.NONE);
		label.setText(CommonUIMessages._59);
		_password = new Text(result, SWT.BORDER);
		_password.setEchoChar('*');
		_password.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		ModifyListener listener = new ModifyListener(){

			public void modifyText(ModifyEvent e) {
				if(_username.getText().trim().length()==0 || _password.getText().trim().length()==0){
					getButton(IDialogConstants.OK_ID).setEnabled(false);
				}else{
					getButton(IDialogConstants.OK_ID).setEnabled(true);
				}
			}
			
		};
		
		_username.addModifyListener(listener);
		_password.addModifyListener(listener);
		return result;
	}
	
	protected void okPressed() {
		_authentication.setUsername(_username.getText());
		_authentication.setPassword( _password.getText());
		super.okPressed();
	}
}
