/*******************************************************************************
 * Copyright (c) 2007, 2008 Intel Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Igor Alelekov, Intel - initial API and implementation
 *    
 * $Id: UIAgentControllerFactory.java,v 1.3 2008/01/24 02:29:14 apnan Exp $
 *
 *******************************************************************************/ 
package org.eclipse.tptp.platform.common.ui.internal.util;

import java.io.IOException;
import java.net.InetAddress;

import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.ConnectionListener;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.security.AuthenticationListener;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;
import org.eclipse.hyades.security.internal.util.ConnectUtilUI;
import org.eclipse.hyades.security.internal.util.IConnectUtilUser;
import org.eclipse.tptp.platform.execution.security.User;
import org.eclipse.tptp.platform.execution.util.internal.AgentControllerFactory;

public class UIAgentControllerFactory extends AgentControllerFactory {
	public User promptAuthentication(String hostName, String userName) {
		ConnectUtilUI cui = new ConnectUtilUI();
		IConnectUtilUser cuUser = cui.promptAuthentication(hostName, userName);
		if(cuUser == null) return null;
		
		return new User(null, cuUser.getName(), cuUser.getPassword());
	}
	
	public User findUser(String hostName) {
		User user = findUserForHost (hostName);
		if (user != null) return user;
		
		if ("localhost".equals(hostName))
			return findUserForHost (null);
		
		return null;
	}
	
	protected User findUserForHost (String hostName) {
		org.eclipse.hyades.internal.execution.local.control.Node node;
		
		try {
			if (hostName != null)
				node = org.eclipse.hyades.internal.execution.local.control.NodeFactory.getNode(hostName, null);
			else
				node = org.eclipse.hyades.internal.execution.local.control.NodeFactory.getNode(InetAddress.getLocalHost(), null);
		} catch (Exception e) {
			node = null;
		}
		
		if (node == null || !node.isConnected()) {
			return null;
		}
		
		org.eclipse.hyades.internal.execution.security.User hyadesUser = node.getUser();
		if (hyadesUser == null) {
			return null;
		}
							// just to extract the password, saving current hyades.User API
		HyadesConnection con = new HyadesConnection();
		try { hyadesUser.login(con); } catch (Exception e) {}
		
		return con.getUser();
	}

	class HyadesConnection implements org.eclipse.hyades.internal.execution.local.control.Connection {
		public User user = null;

		public void sendMessage(ControlMessage msg, CommandHandler handler)	throws IOException {
			int count = msg.getSize();
			if (count <= 1) return;

			org.eclipse.hyades.internal.execution.local.common.CommandElement ce = msg.getCommand(0);
			if (!(ce instanceof org.eclipse.hyades.internal.execution.local.common.AuthenticateCommand)) return;
			
			org.eclipse.hyades.internal.execution.local.common.AuthenticateCommand acmd =
				(org.eclipse.hyades.internal.execution.local.common.AuthenticateCommand) ce;
			
			byte buf[] = new byte[acmd.getSize()];
			acmd.writeToBuffer(buf, 0);

			org.eclipse.hyades.internal.execution.local.common.RAString hyadesName = 
				new org.eclipse.hyades.internal.execution.local.common.RAString();
			
			org.eclipse.hyades.internal.execution.local.common.RAString hyadesPsw = 
				new org.eclipse.hyades.internal.execution.local.common.RAString();

			int offset = org.eclipse.hyades.internal.execution.local.common.Message.readRAStringFromBuffer(buf, 4, hyadesName);
			org.eclipse.hyades.internal.execution.local.common.Message.readRAStringFromBuffer(buf, offset, hyadesPsw);
			
			user = new User(null, hyadesName.getData(), hyadesPsw.getData());
		}

		public void addAuthenticationListener(AuthenticationListener listener) {}
		public void addConnectionListener(ConnectionListener listener) {}
		public void connect(Node node, int port) throws IOException,SecureConnectionRequiredException, LoginFailedException,
				UntrustedAgentControllerException {
		}
		public void disconnect() {}
		public Node getNode() { return null; }
		public int getPort() { return 0; }
		public boolean isActive() {	return false; }
		public void removeAuthenticationListener(AuthenticationListener listener) {}
		public void removeConnectionListener(ConnectionListener listener) {}
		
		public User getUser() { return user; }
	}
}
