/********************************************************************** 
 * Copyright (c) 2006, 2007 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: CommonUIBaseTraceConstants.java,v 1.1 2007/11/27 04:52:13 apnan Exp $
 *
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.tptp.platform.common.ui.trace.internal;

import org.eclipse.tptp.platform.common.internal.ICommonConstants;

public class CommonUIBaseTraceConstants
{

	/**
	 * The id of the trace perspective
	 */
	public static final String ID_TRACE_PERSPECTIVE = "org.eclipse.hyades.trace.internal.ui.tracePerspective";
	public static final String DISPLAY_PROJECTS = "display_projects";
	public static final String RELOAD_INFO = "reload_no_question";
	public static final String ID_PD_NAVIGATOR_VIEW   = "org.eclipse.hyades.trace.internal.ui.PDProjectExplorer";
	
	public static final String TRACE_EXTENSION = "trace";
	
	public static final String HOST_TYPE = "Host";
	public static final String MONITOR_TYPE = "Monitor";
	
	public static final String LOG_PROJECT_NAME = "lprj_name";	
	public static final String LOG_MONITOR_NAME = "lmon_name";	
	
	public static final String PROFILE_REFRESH_GROUP = "refreshGroup";
	public static final String PROFILE_MONITOR_GROUP = "monitoringGroup";
	public static final String PROFILE_ATTACH_GROUP = "attachGroup";
	public static final String PROFILE_NEW_SNAPSHOT_GROUP = "newSnapshotGroup";
	public static final String PROFILE_TERMINATE_GROUP = "terminateGroup";	
	public static final String PROFILE_GC_GROUP = "gcGroup";
	public static final String PROFILING_MONITOR_LAYOUT = "profiling_monitor_layout";
	
	public static final String LOGN_LAYOUT = "logn_layout";
	
	public static final int LAYOUT_FLAT = ICommonConstants.LAYOUT_FLAT;
	public static final int LAYOUT_HIERARCHICAL = ICommonConstants.LAYOUT_HIERARCHICAL;
	
	public static final String SAVE_ON_EXIT_KEY = "save_on_exit";
	
	public static final String TRACE_PROJECT_NAME = "prj_name";
	public static final String TRACE_MONITOR_NAME = "mon_name";
	/**
	 * The id of the log navigator view
	 */
	public static final String ID_LOG_NAVIGATOR_VIEW = "org.eclipse.hyades.log.ui.internal.navigator.LogNavigator";
	
	public final static String TRACE_IMPORT_FILTER_CONTEXT="trace_import_filter_context";
	
	public final static String HIDE_LOGT="hyde_logtype";
	
	/**
	 * Local host
	 */
	public static final String LOCAL_HOST = "localhost";
	
	/**
	 * NM - bugzilla 185476
	 */
	public static final String IAC_NAME = "Local Direct Connection";
}
