/**********************************************************************
 * Copyright (c) 2008 IBM Corporation, Intel Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.tptp.platform.common.ui.views;

/**
 * Extends <code>TableCellLabelProvider</code> with the methods to provide 
 * hover text content for a given cell element in a table. <p>
 * 
 * Columns supporting the custom hover content is listed in <code>IContextAttributes</code>  
 * 
 * @since 4.5
 */
public abstract class TableCellLabelProvider {
	
	/**
	 * Given a cell element and column ID of a table in table viewer, return a
	 * custom hover text string content for the table cell.
	 *  
	 * @param element element of row selection in table 
	 * @param columnID column ID as listed in <code>IContextAttributes</code>.
	 * @return hover text string content
	 */
	public abstract String getColumnHoverText(Object element,String columnID);
	
	/**
	 * Return an array of column ID supported by this provider.
	 * 
	 * @return String array of support column ID as listed in <code>IContextAttributes</code>.
	 */
	public abstract String[] getSupportColumnKeys();
	
	/**
	 * Helper method to verify if a column key is supported by the provider
	 * 
	 * @param columnID 
	 * @return
	 */
	public boolean isSupportColumn(String columnID) {
		String[] columnKeys = getSupportColumnKeys();		
		
		if (columnKeys==null) 
			return false;
		
		for (int i=0;i<columnKeys.length;i++) {
			if (columnKeys[i].equals(columnID))
				return true;
		}	
		return false;
	}
}
