/**********************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TableCellLabelProviderManager.java,v 1.1 2008/03/06 22:12:53 ewchan Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.tptp.platform.common.ui.views;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;

/**
 * This class manages TPTP statistics table column cell hover text provider. 
 * It manages all registered hover text provider. It allows them to be 
 * accessed by column ID key.
 * 
 * @since 4.5
 */
public class TableCellLabelProviderManager {
	
	//instance of context manager
	protected static TableCellLabelProviderManager instance;

	//extension points and elements Id
	protected final String PROVIDER_EXTENSION_POINT = "TableCellLabelProviders";
	protected final String PROVIDER_EXTENSION_POINT_ELEMENT = "tableCellLabelProvider";
	
	protected Map providersByColumnKey;
	
	/**
	 * Return an instance of the manager.
	 * @return instance of manager
	 */
	public static TableCellLabelProviderManager instance()
	{
		if (instance == null)
			instance = new TableCellLabelProviderManager();
		
		return instance;
	}
	
	protected void initializeProviders()
	{
		providersByColumnKey = new HashMap();		
		
		IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tptp.platform.common.ui", PROVIDER_EXTENSION_POINT);

		if (point != null) {
			IConfigurationElement[] elements = point.getConfigurationElements();
			
			for (int i = 0; i < elements.length; i++) {
				
				IConfigurationElement elem = elements[i];
				
				if (elem.getName().equals(PROVIDER_EXTENSION_POINT_ELEMENT)) {
					String id = elem.getAttribute("id");	
//					String name = elem.getAttribute("name");
//					String key = elem.getAttribute("supportColumnIDs");
					
					TableCellLabelProvider tableCellLabelProvider = null;
					String[] keys = null;
					
					try
					{
						if (!"".equals(elem.getAttribute("class"))) {
							Object clz = elem.createExecutableExtension("class");
							if (clz instanceof TableCellLabelProvider) {
								tableCellLabelProvider = (TableCellLabelProvider)clz;
								keys = tableCellLabelProvider.getSupportColumnKeys();
							}
							else {
								CommonPlugin.logError("Class in extension point org.eclipse.tptp.platform.common.ui"+PROVIDER_EXTENSION_POINT+" must implement TableCellLabelProvider");
							}
						}
					}
					catch (Exception e)
					{
						e.printStackTrace();
					}
					
					if(id==null || tableCellLabelProvider==null || keys == null)
						 continue;
	
					for (int j=0;j<keys.length;j++) {
						String colID = keys[j];
						
						Vector providerList = (Vector)(providersByColumnKey.get(colID));
						if (providerList==null) {
							providerList = new Vector();
							providerList.add(tableCellLabelProvider);
							providersByColumnKey.put(colID, providerList);
						}
						else {
							providerList.add(tableCellLabelProvider);
						}	
					}				
				}
			}
		}
	}
	
	protected void initialize() 
	{
		initializeProviders();
	}
	
	protected Vector getProvidersByColID(String colID)
	{
		if (providersByColumnKey==null) 
			initialize();
		
		Vector v = (Vector)providersByColumnKey.get(colID);
		return v; 
	}
	
	public static Vector getProvidersByColIDLKey(String colID) {
		return TableCellLabelProviderManager.instance().getProvidersByColID(colID);
	}
}

