/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ICustomLocationNameValidation.java,v 1.1 2009/04/17 11:44:10 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tptp.platform.common.ui.wizard;

import org.eclipse.core.resources.IContainer;

/**
 * interface designed to let user put its own name validation when creating a location page
 * @version April 16, 2009
 * @author jbozier
 * @since 4.6
 * @provisional Provisional API as of TPTP 4.6.0.
 */
public interface ICustomLocationNameValidation {

	/**
	 * <p>Determines if the resource name based on a target container is valid.</p>
	 * 	 * 
	 * @param  resourceName The resource name.
	 * @param  container The target container.
	 * @return True if the resource name based on a target container is valid, otherwise false.
	 */
	public boolean isNameValid(String resourceName, IContainer container);
	
}
