/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ToolsUiPlugin.java,v 1.28 2009/03/24 16:12:22 paules Exp $
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.recorder.Recorder;
import org.eclipse.hyades.test.core.TestCorePlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * <p>Tools UI plug-in class.</p>
 * 
 * <p><b>Note:</b> This class should not be used outside 
 * the context of Eclipse.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version March 24, 2009
 * @since   February 1, 2005
 */
public class ToolsUiPlugin extends AbstractUIPlugin {
	
	//Plug-in ID:
	public static final String PLUGIN_ID = "org.eclipse.hyades.test.tools.ui"; //$NON-NLS-1$

	//Shared instance of the activator class for this plug-in:
	private static ToolsUiPlugin plugin;

	//Resource bundle:
	private ResourceBundle resourceBundle;
	
	/**
	 * @deprecated As of TPTP 4.5.0, internalized in the <code>org.eclipse.tptp.test.recorders.url</code> plug-in.  
	 */
	public static final String RECORDING_PATH = "recording_path"; //$NON-NLS-1$
	
	/**
	 * @deprecated As of TPTP 4.5.0, internalized in the <code>org.eclipse.tptp.test.recorders.url</code> plug-in.  
	 */
	public static final String RECORDER_APP_ADAPTER = "application_under_test"; //$NON-NLS-1$
	
	/**
	 * @deprecated As of TPTP 4.5.0, internalized in the <code>org.eclipse.tptp.test.recorders.url</code> plug-in.  
	 */
	public static final String PROXY_PORT = "default_proxy_port"; //$NON-NLS-1$
	
	/**
	 * @deprecated As of TPTP 4.5.0, internalized in the <code>org.eclipse.tptp.test.recorders.url</code> plug-in.  
	 */
	public static final String DEFAULT_PORT = "1080";		
		
	/**
	 * The constructor.
	 */
	public ToolsUiPlugin() {
		plugin = this;
	}
	
	/**
	 * Returns the shared instance.
	 */
	public static ToolsUiPlugin getDefault() {
		return plugin;
	}

	/**
     * Resolves the localized message associated with the parameter <code>key</code>
     * based on the default locale from the plugin's resource bundle.
     * <p>
     * If the <code>key</code> does not exist in the plugin's resource bundle, the 
     * <code>key</code> is returned.
     * <p>
     * Noteworthy, the resultant message is not formatted (e.g. no message parameter substitution). 
     * <p>
     * 
     * @param key The <code>key</code> of the message in the plugin's resource bundle.
     * @return The localized message associated with the parameter <code>key</code> from the plugin's resource bundle, otherwise the <code>key</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = ToolsUiPlugin.getDefault().getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
     * Resolves the localized message associated with the parameter <code>key</code>
     * based on the default locale from the plugin's resource bundle.
     * <p>
     * If the <code>key</code> does not exist in the plugin's resource bundle, the 
     * <code>key</code> is returned.
     * <p>
     * Noteworthy, the resultant message is not formatted (e.g. no message parameter substitution). 
     * <p>
     * 
     * @param key The <code>key</code> of the message in the plugin's resource bundle.
     * @return The localized message associated with the parameter <code>key</code> from the plugin's resource bundle, otherwise the <code>key</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public static String getString(String key)
    {
        return getResourceString(key);
    }

    /**
     * Resolves the localized and formatted message associated with the parameter <code>key</code>
     * based on the default locale from the plugin's resource bundle.
     * <p>
     * Message formatting is done by the {@link org.eclipse.osgi.util.NLS} class using the 
     * default locale. 
     * <p>
     * If the <code>key</code> does not exist in the plugin's resource bundle, the 
     * <code>key</code> is returned.
     * <p>
     * 
     * @param key The <code>key</code> of the message in the plugin's resource bundle.
     * @param argument The first message parameter for formatting in the localized and formatted message.
     * @return The localized message associated with the parameter <code>key</code> from the plugin's resource bundle, otherwise the <code>key</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public static String getString(String key, String argument)
    {
        return getString(key, new String[] {argument});
    }   

    /**
     * Resolves the localized and formatted message associated with the parameter <code>key</code>
     * based on the default locale from the plugin's resource bundle.
     * <p>
     * Message formatting is done by the {@link org.eclipse.osgi.util.NLS} class using the 
     * default locale. 
     * <p>
     * If the <code>key</code> does not exist in the plugin's resource bundle, the 
     * <code>key</code> is returned.
     * <p>
     * 
     * @param key The <code>key</code> of the message in the plugin's resource bundle.
     * @param arguments The array of message parameters for formatting in the localized and formatted message.
     * @return The localized message associated with the parameter <code>key</code> from the plugin's resource bundle, otherwise the <code>key</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public static String getString(String key, String[] arguments)
    {
        return NLS.bind(getString(key), ((Object[])(arguments)));
    }
    
    /**
     * Resolves the plugin's resource bundle.
     * <p>
     * If the plugin's resource bundle can not be resolved, <code>null</code> is returned.
     * <p>
     * IMPORTANT: Do not use this method to retrieve values from the resource bundle.  This method 
     * is provided so this plugin's resource bundle can be used as the parent of another plugin's 
     * resource bundle.
     * <p>
     * 
     * @return The plugin's resource bundle, otherwise <code>null</code>.
     * @deprecated As of TPTP V4.4, use {@link org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle} for resolving resources.  The plugin.properties property file ONLY contains messages for the this plug-in's MANIFEST.MF and plugin.xml files.
     */
    public ResourceBundle getResourceBundle() {
        try {
            if (resourceBundle == null)
                resourceBundle   = Platform.getResourceBundle(Platform.getBundle(PLUGIN_ID));
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
        return resourceBundle;
    }
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {

		//Force the org.eclipse.hyades.test.core plug-in to be loaded thereby causing the org.eclipse.hyades.test.core.TestCorePlugin.start(BundleContext) 
		//method to be invoked to register the resource factories:
		TestCorePlugin.getDefault();

        super.start(context);        
	}
	
	/**
	 * Returns this plugin's id.
	 * @return String
	 */
	public static String getID()
	{
		return PLUGIN_ID;
	}

	public static void storePreference(String key, String value){
		getDefault().getPreferenceStore().setValue(key,value);
	}

	public static String getPreference(String key){
		return getDefault().getPreferenceStore().getString(key);
	}

	/**
	 * Logs an error described by a throwable.
	 * 
	 * <p>This method should be used whenever a class in this plugin
	 * has to log an error since it adheres to the global logging
	 * strategy.
	 * 
	 * @param throwable
	 */
	public static void logError(Throwable exc)
	{
		Status status = new Status(1, getID(), 0, exc.toString(), exc);
		getDefault().getLog().log(status);
	}
	
	/**
	 * Logs an error described by a text.
	 * 
	 * <p>This method should be whenever a class in this plugin
	 * has to log an error since it adheres to the global logging
	 * strategy.
	 * 
	 * @param text
	 */
	public static void logError(String text)
	{
		logError(new Throwable(text));
	}
	
	// Recorder Stuff
	/**
	 * @deprecated As of TPTP 4.5.0, internalized in the <code>org.eclipse.tptp.test.recorders.url</code> plug-in.  
	 */
	public void getRecorderInfo() {
		//No-operation since only for API compatability.
	}
	
	/**
	 * This method always returns <code>null</code> for API compatability.
	 * <p/>
	 * 
	 * @return Always returns <code>null</code>.
	 * @deprecated As of TPTP 4.5.0, internalized in the <code>org.eclipse.tptp.test.recorders.url</code> plug-in.
	 */
	public Recorder getRecorder(){

		//Return null since only for API compatability.
		return null;
	}	
}
