/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCommonImages.java,v 1.8 2009/03/24 16:12:23 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common;

import java.net.URL;

import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * <p>Test Common image manager.</p>
 * 
 * <p><b>Note:</b>This class is not intended to be extended 
 * or used externally, and images are subject to be changed 
 * without notice.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Marcelo Paternostro
 * @version March 24, 2009
 * @since   February 1, 2005
 */
public class TestCommonImages
extends ImageManager
{
	/**
	 * TestCommonImages' singleton.
	 */
	public static final TestCommonImages INSTANCE = new TestCommonImages();
	
	/**
	 * No-argument constructor.
	 */
	public TestCommonImages(){
		
		try	{
			initialize(new URL(ToolsUiPlugin.getDefault().getBundle().getEntry("/"), "icons/full/"), ToolsUiPlugin.getDefault().getImageRegistry()); //$NON-NLS-1$ //$NON-NLS-2$
		}
		catch(Exception e) {
			ToolsUiPlugin.logError(e);
		}	
	}
	
	/**
	 * @deprecated As of TPTP 4.5.0, test report providers must provide their own report wizard banner.
	 */
	public static final String IMG_WIZBAN_REPORT_WINDOW         = "report_window_wiz.gif"; //$NON-NLS-1$

	/*
	 * Available cached Images in the Common plugin image registry.
	 */
	public static final String IMG_WIZBAN_GENERATE   	        = "generate_wiz.gif"; //$NON-NLS-1$    
	public static final String IMG_LOOP	 				    	= "loop.gif"; //$NON-NLS-1$
	public static final String IMG_INVOCATION			    	= "invocation.gif"; //$NON-NLS-1$
	
	/**
	 * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
	 */
	protected void addImages()
	{
		add(T_WIZBAN, IMG_WIZBAN_GENERATE);
        add(T_WIZBAN, IMG_WIZBAN_REPORT_WINDOW);

		add(T_OBJ, IMG_LOOP);
		add(T_OBJ, IMG_INVOCATION);
	}	
}
