/*******************************************************************************
 * Copyright (c) 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestPropertySource.java,v 1.1 2009/04/08 10:15:56 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal;

import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.test.ui.adapter.CMNNamedElementPropertySource;
import org.eclipse.hyades.test.ui.adapter.INamedElementPropertySource;
import org.eclipse.hyades.test.ui.navigator.CMNNamedElementProxyNode;
import org.eclipse.hyades.test.ui.navigator.IExecutionResultProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestComponentProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.ui.views.properties.IPropertySource;

/**
 * <p>TestPropertySource.java</p>
 * 
 * 
 * @author  Paul Slauenwhite
 * @version April 7, 2009
 * @since   April 7, 2009
 */
public class TestPropertySource implements INamedElementPropertySource {

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.adapter.INamedElementPropertySource#getPropertySource(java.lang.Object)
	 */
	public IPropertySource getPropertySource(Object adaptableObject) {
		
		if(adaptableObject instanceof ITestSuiteProxyNode) {
			return (new CMNNamedElementPropertySource(((ITestSuiteProxyNode)(adaptableObject)).getTestSuite()));
		} 
		else if(adaptableObject instanceof ITestCaseProxyNode) {
			return (new CMNNamedElementPropertySource(((ITestCaseProxyNode)(adaptableObject)).getTestCase()));
		} 
		else if(adaptableObject instanceof ITestComponentProxyNode) {
			return (new CMNNamedElementPropertySource(((ITestComponentProxyNode)(adaptableObject)).getTestComponent()));
		} 
		else if(adaptableObject instanceof IExecutionResultProxyNode) {
			return (new CMNNamedElementPropertySource(((IExecutionResultProxyNode)(adaptableObject)).getExecutionResult()));
		}
		else if(adaptableObject instanceof CMNNamedElementProxyNode){
			return (new CMNNamedElementPropertySource(((CMNNamedElementProxyNode)(adaptableObject))));			
		}
		else if (adaptableObject instanceof CMNNamedElement){
			return (new CMNNamedElementPropertySource((CMNNamedElement)(adaptableObject)));
		}
		
		return null;
	}
}
