/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BehaviorAccessories.java,v 1.7 2008/07/14 19:18:48 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.facades.behavioral.IAction;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.common.TestCommonImages;
import org.eclipse.hyades.test.tools.ui.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.AddLoop;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.AddTestInvocation;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.BehaviorActionGroup;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.InsertLoop;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.InsertTestInvocation;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.util.ContextIds;
import org.eclipse.hyades.test.tools.ui.java.internal.util.TestJavaUtil;
import org.eclipse.hyades.test.ui.adapter.TestAdapterFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.TreePart;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTree;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTreeContentProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.SelectionListenerAction;

/**
 * The content provider and the label provider for the behavior form
 * <p/>
 * 
 * 
 * @author      Ali Mehregani
 * @author      Marcelo Paternostro
 * @author      Paul E. Slauenwhite
 * @version     July 14, 2008
 * @since       August 19, 2005
 */
public class BehaviorAccessories 
{
	public static class BehaviorContentProvider
	extends EObjectTreeContentProvider
	{
		/**
		 * Constructor for BehaviorContentProvider
		 * @param editorForm
		 * @param eStructuralFeature
		 */
		public BehaviorContentProvider(IEditorExtension editorForm, EStructuralFeature eStructuralFeature)
		{
			super(editorForm, eStructuralFeature);
		}

		/**
		 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
		 */
		public void dispose()
		{
			if(getContainer() != null)
				EMFUtil.removeAdapter(getContainer().eResource().getAllContents(), this);
				
			super.dispose();
		}

		/**
		 * 
		 */
		protected void deregisterInputAdapters(EObject oldInput, Object value)
		{
			if(oldInput.eResource() != null)
				EMFUtil.removeAdapter(oldInput.eResource().getAllContents(), this);
		}

		/**
		 * 
		 */
		protected void registerInputAdapters(EObject newInput, Object value)
		{
			EMFUtil.addAdapter(newInput.eResource().getAllContents(), this);
		}

		/**
		 * 
		 */
		public Object getParent(Object element)
		{
			if(element instanceof IAction)
			{
				EObject eObject = ((EObject)element).eContainer();
				while((!(eObject instanceof ILoop)) && (eObject != null))
					eObject = eObject.eContainer();
				return eObject;
			}
			
			return super.getParent(element);
		}

		/**
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
		 */
		public boolean hasChildren(Object element)
		{
			if(super.hasChildren(element))
				return true;
				
			if(element instanceof ILoop)
				return !((ILoop)element).getBlock().getActions().isEmpty();
				
			return false;
		}

		/**
		 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
		 */
		public Object[] getChildren(Object parentElement)
		{
			if(parentElement instanceof ILoop)
				return ((ILoop)parentElement).getBlock().getActions().toArray();

			return super.getChildren(parentElement);
		}

		/**
		 * 
		 */
		protected void adjustAdapter(Notification msg)
		{
			EObject eObject = null;
			switch(msg.getEventType())
			{
				case Notification.ADD:
					eObject = (EObject)msg.getNewValue();
					eObject.eAdapters().add(this);
					EMFUtil.addAdapter(eObject.eAllContents(), this);
					break;

				case Notification.ADD_MANY:
					for (Iterator i = ((Collection)msg.getNewValue()).iterator(); i.hasNext();)
						EMFUtil.addAdapter(((EObject)i.next()).eAllContents(), this);
					break;
					
				case Notification.REMOVE:
					eObject = (EObject)msg.getOldValue();
					eObject.eAdapters().remove(this);
					EMFUtil.removeAdapter(eObject.eAllContents(), this);
					break;

				case Notification.REMOVE_MANY:
				for (Iterator i = ((Collection)msg.getOldValue()).iterator(); i.hasNext();)
					EMFUtil.removeAdapter(((EObject)i.next()).eAllContents(), this);
				break;
			}
		}

		/**
		 * 
		 */
		protected boolean shouldUpdateViewer(Notification msg)
		{
			if(super.shouldUpdateViewer(msg))
				return true;
					
			return ((msg.getNotifier() instanceof IBlock) && (msg.getFeature() == Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand_InteractionFragments()));
		}
		
		/**
		 * 
		 */
		protected void attributeChanged(Notification msg)
		{
			super.attributeChanged(msg);
			
			if((getViewer() != null) && (msg.getFeature() == Common_Behavior_InteractionsPackage.eINSTANCE.getBVRExecutionOccurrence_OtherBehavior()) && (msg.getNotifier() instanceof ITestInvocation))
			{
				IStructuredSelection structuredSelection = (IStructuredSelection)getViewer().getSelection();
				if(structuredSelection.isEmpty())
					return;
					
				if(structuredSelection.getFirstElement() == msg.getNotifier())
					UIUtil.fireCurrentSelection((StructuredViewer)getViewer());
			}
		}
	}
	
	
	
	/******************************************************************************************
	 * The label provider
	 ******************************************************************************************/
	public static class BehaviorLabelProvider
	extends LabelProvider
	{	
		/**
		 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
		 */
		public String getText(Object element)
		{
			return TestAdapterFactory.INSTANCE.getHyadesWorkbenchAdapter().getLabel(element);
		}

		/**
		 * @see org.eclipse.jface.viewers.ILabelProvider#getImage(java.lang.Object)
		 */
		public Image getImage(Object element)
		{
			if(element instanceof ILoop)
				return TestCommonImages.INSTANCE.getImage(TestCommonImages.IMG_LOOP);

			if(element instanceof ITestInvocation)
				return TestCommonImages.INSTANCE.getImage(TestCommonImages.IMG_INVOCATION);

			ImageDescriptor imageDescriptor = TestAdapterFactory.INSTANCE.getHyadesWorkbenchAdapter().getImageDescriptor(element);
			if(imageDescriptor != null)
				return imageDescriptor.createImage();
				
			return null;
		}
	}
	
	
	/******************************************************************************************
	 * The extended eobject tree
	 ******************************************************************************************/
	public class ExtendedObjectTree 
	extends EObjectTree
	{
		/* Help flags */
		protected static final int HELP_SECTION_CONTROL = 1;
		protected static final int HELP_SECTION_UP_ACTION = 2;
		protected static final int HELP_SECTION_DOWN_ACTION = 3;
	    
	    protected static final int HELP_SECTION_ADD_LOOP_ACTION = 4;
	    protected static final int HELP_SECTION_ADD_INV_ACTION = 5;
		

        /* The Add action group */
		private BehaviorActionGroup addBehaviorActionGroup;
		
		/* The insert action group */
	    private BehaviorActionGroup insertBehaviorActionGroup;
	    
	    /* The behavior form */
	    private BehaviorEclipseForm behaviorForm;
			
		/**
		 * Constructor 
		 */
		public ExtendedObjectTree(BehaviorEclipseForm behaviorForm)
		{
			super(behaviorForm.getFormEditor(), Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction_InteractionFragments(), null);
			this.behaviorForm = behaviorForm;
		}
		

		/**
		 * A chance to clean up
		 */
		public void dispose()
		{
			if(addBehaviorActionGroup != null)
				addBehaviorActionGroup.dispose();

	        if(insertBehaviorActionGroup != null)
	            insertBehaviorActionGroup.dispose();

			super.dispose();
		}
		
		/**
		 * Returns the test suite
		 * 
		 * @return The test suite
		 */
		public ITestSuite getTestSuite()
		{
			return behaviorForm.getTestSuite();
		}

		
		/**
		 * 
		 */
		protected void adjustButtonLabels(String addLabel)
		{
			super.adjustButtonLabels(UiPluginResourceBundle.BTN_ADD, UiPluginResourceBundle.BTN_INSERT);  
		}
		
		/**
		 * 
		 */
		protected void adjustClient(Composite parent)
		{
			super.adjustClient(parent);

			registerHelp(HELP_SECTION_CONTROL, getTreeViewer().getControl());				
			registerHelp(HELP_SECTION_UP_ACTION, moveUpAction);				
			registerHelp(HELP_SECTION_DOWN_ACTION, moveDownAction);
		}
	    
	    /**
	     * @see org.eclipse.hyades.test.ui.internal.editor.form.base.BaseStructuredViewerSection#buttonSelected(int)
	     */
	    protected void buttonSelected(int index)
	    {
	        if(!behaviorForm.getFormEditor().getHyadesEditorPart().isReadOnly())
	        {
	            switch(index)
	            {
	                case 0:
	                    doAdd();
	                    break;
	                
	                case 1:
	                    doInsert();
	                    break;
	    
	                case 2:
	                    doRemove();
	                    break;
	    
	                case 3:
	                    doMoveUp();
	                    break;
	    
	                case 4:
	                    doMoveDown();
	                    break;
	                
	            }
	        }
	        
	        updateActionsAndButtons((IStructuredSelection)super.getViewerPart().getViewer().getSelection());
	    }

		/**
		 *
		 */
		protected void createActions()
		{	
			addBehaviorActionGroup = createAddBehaviorActionGroup();
	        insertBehaviorActionGroup = createInsertBehaviorActionGroup();
			super.createActions();
		}
		
		/**
		 * 
		 */
		protected IContentProvider createContentProvider()
		{
			return new BehaviorContentProvider(behaviorForm.getFormEditor(), getEStructuralFeature());
		}

		/**
		 * 
		 */
		protected ILabelProvider createLabelProvider()
		{
			return new BehaviorLabelProvider();
		}

		/**
		 * 
		 */
		protected void fillContextMenu(IMenuManager menuManager)
		{
			if(addBehaviorActionGroup != null)
			{
				addBehaviorActionGroup.fillContextMenu(menuManager);
				if(behaviorForm.getFormEditor().getHyadesEditorPart().isReadOnly())
					addBehaviorActionGroup.disableActions();
			}
	        
	        if(insertBehaviorActionGroup != null)
	        {
	            insertBehaviorActionGroup.fillContextMenu(menuManager);
				if(behaviorForm.getFormEditor().getHyadesEditorPart().isReadOnly())
					insertBehaviorActionGroup.disableActions();
	        }
				
			super.fillContextMenu(menuManager);
		}

		/**
		 * 
		 */
		protected void doAdd()
		{
			if(addBehaviorActionGroup != null)
			{
				Menu menu = ((TreePart)getViewerPart()).getButtonMenu(0);
				addBehaviorActionGroup.fillContextMenu(menu, true);
				menu.setVisible(true);
			}
		}

	    protected void doInsert()
	    {
	        if(insertBehaviorActionGroup != null)
	        {
	            Menu menu = ((TreePart)getViewerPart()).getButtonMenu(1);
	            insertBehaviorActionGroup.fillContextMenu(menu, true);
	            menu.setVisible(true);
	        }
	    }

		/**
		 * @see org.eclipse.hyades.test.ui.internal.editor.form.util.StructuredViewerSection#updateActionsAndButtons(org.eclipse.jface.viewers.IStructuredSelection)
		 */
		protected void updateActionsAndButtons(IStructuredSelection structuredSelection)
		{
	        if(addBehaviorActionGroup != null)
	        {
	            addBehaviorActionGroup.setContext(new ActionContext(structuredSelection));
	            ((TreePart)getViewerPart()).setButtonEnabled(0, addBehaviorActionGroup.isEnabled());
	        }

	        if(insertBehaviorActionGroup != null)
	        {
	            insertBehaviorActionGroup.setContext(new ActionContext(structuredSelection));
	            ((TreePart)getViewerPart()).setButtonEnabled(1, insertBehaviorActionGroup.isEnabled());
	        }
	        
	        if((!structuredSelection.isEmpty()) && (((EObject)structuredSelection.getFirstElement()).eContainer() != getViewerPart().getViewer().getInput()))
	        {
	            moveUpAction.setEStructuralFeature(Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand_InteractionFragments());
	            moveDownAction.setEStructuralFeature(Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand_InteractionFragments());
	        }
	        else
	        {
	            moveUpAction.setEStructuralFeature(getEStructuralFeature());
	            moveDownAction.setEStructuralFeature(getEStructuralFeature());          
	        }
	        
	        if(addAction != null)
	        {
	            if(addAction instanceof SelectionListenerAction)
	                ((SelectionListenerAction)addAction).selectionChanged(structuredSelection);
	            ((TreePart)getViewerPart()).setButtonEnabled(0, addAction.isEnabled());
	        }

	        if(insertAction != null)
	        {
	            if(insertAction instanceof SelectionListenerAction)
	                ((SelectionListenerAction)insertAction).selectionChanged(structuredSelection);
	            ((TreePart)getViewerPart()).setButtonEnabled(1, insertAction.isEnabled());
	        }
	        
	        if(removeAction != null)
	        {
	            removeAction.selectionChanged(structuredSelection);
	            ((TreePart)getViewerPart()).setButtonEnabled(2, removeAction.isEnabled());
	        }

	        if(moveDownAction != null)
	        {
	            moveDownAction.selectionChanged(structuredSelection);
	            ((TreePart)getViewerPart()).setButtonEnabled(4, moveDownAction.isEnabled());
	        }
	        
	        if(moveUpAction != null)
	        {
	            moveUpAction.selectionChanged(structuredSelection);
	            ((TreePart)getViewerPart()).setButtonEnabled(3, moveUpAction.isEnabled());
	        }           
		}
	    
	    /**
	     * @see org.eclipse.hyades.test.common.internal.editor.BehaviorSection#createAddBehaviorActionGroup()
	     */
	    protected BehaviorActionGroup createAddBehaviorActionGroup()
	    {
	        BehaviorActionGroup group = new BehaviorActionGroup(behaviorForm, UiPluginResourceBundle.LBL_ADD); 

	        AddLoop addLoop = new AddLoop(behaviorForm, ToolsUiPluginResourceBundle.LBL_LOOP, ToolsUiPluginResourceBundle.W_LOOP);  
	        registerHelp(HELP_SECTION_ADD_LOOP_ACTION, addLoop);
	        group.addAction(addLoop);

	        AddTestInvocation addTestInvocation = new AddTestInvocation(behaviorForm, ToolsUiPluginResourceBundle.W_LWR_INV) 
	        {
	            protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite)
	            {
	                return TestJavaUtil.createInvokedTestSelectionDialog(testSuite, false);
	            }               
	        };
	        registerHelp(HELP_SECTION_ADD_INV_ACTION, addTestInvocation);
	        group.addAction(addTestInvocation);
	        
	        return group;
	    }
	    
	    /**
	     * @see org.eclipse.hyades.test.common.internal.editor.BehaviorSection#createAddBehaviorActionGroup()
	     */
	    protected BehaviorActionGroup createInsertBehaviorActionGroup()
	    {
			BehaviorActionGroup group = new BehaviorActionGroup(behaviorForm, UiPluginResourceBundle.LBL_INSERT); 

	        InsertLoop insertLoop = new InsertLoop(behaviorForm, ToolsUiPluginResourceBundle.LBL_LOOP, ToolsUiPluginResourceBundle.W_LOOP);  
	        registerHelp(HELP_SECTION_ADD_LOOP_ACTION, insertLoop);
	        group.addAction(insertLoop);

	        InsertTestInvocation insertTestInvocation = new InsertTestInvocation(behaviorForm, ToolsUiPluginResourceBundle.W_LWR_INV) 
	        {
	            protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite)
	            {
	                return TestJavaUtil.createInvokedTestSelectionDialog(testSuite, false);
	            }               
	        };
	        registerHelp(HELP_SECTION_ADD_INV_ACTION, insertTestInvocation);
	        group.addAction(insertTestInvocation);
	        
	        return group;
	    }
	    
	    /**
	     * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#registerHelp(int, java.lang.Object)
	     */
	    protected void registerHelp(int flag, Object object)
	    {
	        switch(flag)
	        {
	            case HELP_SECTION_CONTROL:
	            	ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Control)object, ToolsUiPlugin.getID() + ContextIds.BEHAVIOR_SECTION);                
	                break;
	                
	            case HELP_SECTION_DOWN_ACTION:
	            	ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Action)object, ToolsUiPlugin.getID() + ContextIds.BEHAVIOR_SECTION_DOWN);
	                break;
	                
	            case HELP_SECTION_UP_ACTION:
	            	ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Action)object, ToolsUiPlugin.getID() + ContextIds.BEHAVIOR_SECTION_UP);              
	                break;

	            case HELP_SECTION_ADD_LOOP_ACTION:
	            	ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Action)object, ToolsUiPlugin.getID() + ContextIds.ACT_ADD_LOOP);
	                break;
	                
	            case HELP_SECTION_ADD_INV_ACTION:
	            	ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp((Action)object, ToolsUiPlugin.getID() + ContextIds.ACT_ADD_TEST_INV);             
	                break;
	        }
	    }

	}
}
