/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BehaviorForm.java,v 1.7 2007/04/19 18:32:25 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.StaticDetailPageProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

/**
 * Form for the <code>Behavior</code> tab.
 * <p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @version March 14, 2007
 * @since   February 1, 2005
 * @since   1.0.2
 */
abstract public class BehaviorForm
extends EditorForm implements ISelectionChangedListener, IITestSuiteProvider
{
	protected static final int HELP_FORM_CONTROL = 1;
	protected static final int HELP_SECTION_CONTROL = 2;
	protected static final int HELP_NAMED_ELEMENT_CONTROL = 3;

	private BehaviorSection behaviorSection;
	private NamedElementSection commonSection;
	private DetailSection detailSection;
	private boolean firstActivation = true;
	
	/**
	 * Constructor for BehaviorForm
	 * @param testSuiteEditorExtension
	 * @param widgetFactory
	 */
	public BehaviorForm(BaseEditorExtension testSuiteEditorExtension, WidgetFactory widgetFactory)
	{
		super(testSuiteEditorExtension, widgetFactory);
	}

	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		behaviorSection.getTreeViewer().removeSelectionChangedListener(this);
		behaviorSection.dispose();
		commonSection.dispose();
		if(detailSection != null)
			detailSection.dispose();
		
		super.dispose();
	}

	/**
	 * @see org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider#getTestSuite()
	 */
	public ITestSuite getTestSuite()
	{
		return ((IITestSuiteProvider)getBaseEditorExtension()).getTestSuite();		
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#createEditorFormContents(org.eclipse.swt.widgets.Composite)
	 */
	protected void createEditorFormContents(Composite parent)
	{
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.makeColumnsEqualWidth = true;
		gridLayout.marginWidth = 10;
		gridLayout.horizontalSpacing = 15;
		parent.setLayout(gridLayout);

		Composite leftColumn = createColumn(parent);
		Composite rightColumn = createColumn(parent);
		
		behaviorSection = createBehaviorSection();
		registerSection(behaviorSection);
		behaviorSection.setHeaderText(UiPluginResourceBundle.W_BEHAVIOR);
		Control control = behaviorSection.createControl(leftColumn, getWidgetFactory());
		control.setLayoutData(new GridData(GridData.FILL_BOTH | GridData.VERTICAL_ALIGN_BEGINNING));		
		
		commonSection = new NamedElementSection(this);
		commonSection.setHeaderText(UiPluginResourceBundle.TTL_CMN_PROPS);
		registerSection(commonSection);		
		control = commonSection.createControl(rightColumn, getWidgetFactory());
		GridData gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
		control.setLayoutData(gridData);
		
		StaticDetailPageProvider detailPageProvider = new StaticDetailPageProvider();
		addDetails(detailPageProvider);	
		if(!detailPageProvider.isEmpty())
		{
			detailSection = new DetailSection(this);
			detailSection.setDetailPageProvider(detailPageProvider);
			detailSection.setHeaderText(UiPluginResourceBundle.TTL_DTL_PROPS);
			registerSection(detailSection);
			control = detailSection.createControl(rightColumn, getWidgetFactory());
			gridData = new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING);
			control.setLayoutData(gridData);
		}
		
		registerHelp(HELP_FORM_CONTROL, parent);
		registerHelp(HELP_SECTION_CONTROL, leftColumn);
		registerHelp(HELP_NAMED_ELEMENT_CONTROL, rightColumn);
	}
	
	abstract protected BehaviorSection createBehaviorSection();
	
	protected void addDetails(StaticDetailPageProvider detailPageProvider)
	{
	}
	
	protected void registerHelp(int flag, Object object)
	{
	}

	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#load()
	 */
	public void load()
	{
		behaviorSection.getTreeViewer().removeSelectionChangedListener(this);
		behaviorSection.setInput(getTestSuite().getImplementor().getBlock());
		behaviorSection.getTreeViewer().addSelectionChangedListener(this);
		
		//By default, select the first item in the tree:
		Tree tree = behaviorSection.getTreeViewer().getTree();
		
		if(tree.getItemCount() > 0){
			selectReveal(new StructuredSelection(tree.getItem(0).getData()));
		}
	}
	
	/**
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection)
	{
		behaviorSection.selectReveal(selection);
	}
	
	/**
	 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
	 */
	public void selectionChanged(SelectionChangedEvent event)
	{
		if(event.getSource() == behaviorSection.getTreeViewer())
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)getSelection();
			commonSection.setInput(structuredSelection);
			if(detailSection != null)
				detailSection.setInput(structuredSelection);
		}
	}
	
	public ISelection getSelection()
	{
		return behaviorSection.getTreeViewer().getSelection();
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#activated()
	 */
	public boolean activated()
	{
		if(firstActivation)
		{
			firstActivation = false;
			behaviorSection.setFocus();
		}
			
		return true;
	}
	
	/**
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.common.EditorForm#updateTitle()
	 */
	public void updateTitle()
	{
	}	
}
