/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: LoopDetailForm.java,v 1.1 2005/08/19 21:23:23 hleung Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.AbstractDetailForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;


/**
 * This class is an alternative implementation of 
 * org.eclipse.hyades.test.tools.ui.common.internal.editor.LoopDetailPage that conforms to the
 * Eclipse forms API.
 * 
 * @author Ali Mehregani
 * @author marcelop
 * @since 1.0.2
 */
public abstract class LoopDetailForm extends AbstractDetailForm 
implements ModifyListener, SelectionListener
{
	protected static final int HELP_PAGE_CONTROL = 1;
	protected static final int HELP_ITERATION_CONTROL = 2;
	protected static final int HELP_SYNCHRONOUS_CONTROL = 3;

	private Button synchronousButton;
	private Text iteractionsText;
	
	private ILoop loop;
	
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		loop = null;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormToolkit widgetFactory, IDetailPageContext context)
	{
		super.context = context;

		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());

		synchronousButton = widgetFactory.createButton(composite, getSynchronousLabel(), SWT.CHECK);
		synchronousButton.setLayoutData(GridDataUtil.createHorizontalFill());

		widgetFactory.createLabel(composite, getIteractionsLabel());
		iteractionsText = widgetFactory.createText(composite, getIteractionsLabel());
		iteractionsText.setLayoutData(GridDataUtil.createHorizontalFill());
		
		widgetFactory.paintBordersFor(composite);
		
		registerHelp(HELP_PAGE_CONTROL, composite);				
		registerHelp(HELP_ITERATION_CONTROL, iteractionsText);				
		registerHelp(HELP_SYNCHRONOUS_CONTROL, synchronousButton);				
		
		return composite;
	}
	
	abstract protected String getSynchronousLabel();
	abstract protected String getIteractionsLabel();
	
	protected void registerHelp(int flag, Object object)
	{
	}

	/**
	 * 
	 */
	public void setInput(Object object)
	{
		loop = null;

		synchronousButton.removeSelectionListener(this);
		iteractionsText.removeVerifyListener(this);
		iteractionsText.removeModifyListener(this);

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		if(object instanceof ILoop)
		{
			loop = (ILoop)object;
			
			String value = loop.getCondition().getConstraint();
			if(value != null)
				iteractionsText.setText(value);
			else
				iteractionsText.setText("");

			synchronousButton.setSelection(loop.isSynchronous());
			iteractionsText.setEditable(true);			
		}
		else
		{
			synchronousButton.setEnabled(false);
			iteractionsText.setText("");
		}
		
		synchronousButton.addSelectionListener(this);
		iteractionsText.addVerifyListener(this);
		iteractionsText.addModifyListener(this);
	}

	/**
	 *
	 */
	public Object getInput()
	{
		return loop;
	}

	/**
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e)
	{
		e.doit = !isReadOnly();
	}

	/**
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e)
	{
		if(isReadOnly())
		{
			e.doit = false;
		}
		else
		{
			if(e.widget == synchronousButton)
			{
				loop.setSynchronous(synchronousButton.getSelection());
				if (getEditorForm().getFormEditor() instanceof BaseEditorExtension)
					((BaseEditorExtension)getEditorForm().getFormEditor()).markDirty();
			}
		}		
	}	
	
	/**
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e)
	{
		if(e.widget == iteractionsText)
		{
			loop.getCondition().setConstraint(iteractionsText.getText());
			if (getEditorForm().getFormEditor() instanceof BaseEditorExtension)
				((BaseEditorExtension)getEditorForm().getFormEditor()).markDirty();
		}
	}


	public void verifyText(VerifyEvent e)
	{
		super.verifyKey(e);
		UIUtil.integerStyledTextVerifyKey(e);
		
	}



	public void selectReveal(ISelection selection)
	{
		// TODO Auto-generated method stub
		
	}

	public IStructuredSelection getStructuredSelection()
	{
		// TODO Auto-generated method stub
		return null;
	}




}
