/**********************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OverviewEclipseForm.java,v 1.10 2007/04/26 20:23:32 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.common.CommonPackage;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.tools.ui.common.internal.util.FormUtil;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.tools.ui.common.internal.util.TestCaseAdapter;
import org.eclipse.hyades.test.tools.ui.common.internal.util.FormUtil.CommonSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorEclipseForm;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.hyades.ui.editor.IHyadesEditorPartExtended;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/**
 * This class was created in response to the deprecated APIs about the way that
 * forms are currently handled.
 * 
 * <p>
 * This class represents the overview form that appears in the multi-page test
 * suite editor
 * </p>
 * 
 * @author Ali Mehregani & marcelop
 */
public class OverviewEclipseForm extends EditorEclipseForm
implements IITestSuiteProvider
{

	/* The id of the test case form */
	private String testCasesPageID;

	/* The form editor that this form is apart of */
	private IEditorExtension editor;
	
	/* Composite for the test case hyper links */ 
	private Composite hyperlinkComposite;

	/* The adapter listening for changes on the test case form */
	private TestCaseAdapter testcaseAdapter;
	
	/* Common section */
	private Section sectionc;
	private CommonSection commonSection;
	
	/**
	 * The constructor
	 * 
	 * @param hyadesEditorPart
	 *            The form editor that this form is apart of
	 * @param id
	 *            The id of the form
	 * @param title
	 *            The title of the form
	 */
	public OverviewEclipseForm(IEditorExtension hyadesEditorPart, String editorTitle, String id, String title)
	{
		super(hyadesEditorPart, editorTitle, id, title);
		editor = hyadesEditorPart;
		
		hyperlinkComposite = null;
		testcaseAdapter = null;
		registerAdapter((EObject)getTestSuite(), Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(), null);				
	}

	
	/**
	 * A helper method used to register an adapter so that we can listen to changes to the test cases
	 */
	private void registerAdapter(EObject container, EStructuralFeature namedElementFeature, String statusLinePrefix)
	{
		if(!CommonPackage.eINSTANCE.getCMNNamedElement().isSuperTypeOf((EClass)namedElementFeature.getEType()))
			return;
			
		if(!namedElementFeature.isMany())
			return;
			
		testcaseAdapter = new TestCaseAdapter(hyperlinkComposite, namedElementFeature, statusLinePrefix, editor);
		container.eAdapters().add(testcaseAdapter);
		testcaseAdapter.setTarget(container);
	}

	/**
	 * Clean up after your self
	 */
	public void dispose()
	{	
		if (hyperlinkComposite != null)
		{
			hyperlinkComposite.dispose();
			hyperlinkComposite = null;
		}
		
		if (testcaseAdapter != null)
		{
			testcaseAdapter.dispose();
			testcaseAdapter = null;
		}
		
		if (sectionc != null)
		{
			sectionc.dispose();
			sectionc = null;
		}
		
		if (commonSection != null)
		{
			commonSection.dispose();
			commonSection = null;
		}
				
		super.dispose();
	}

	/**
	 * Sets the id of the test case page. This id needs to be stored
	 * because this form references it when the user clicks on the 'more' button
	 * of the overview form.
	 * 
	 * @param id
	 *            The id of the test case form/page.
	 */
	public void setTestCasePageID(String id)
	{
		testCasesPageID = id;
	}

	/**
	 * Create the left column controls for this form
	 * 
	 * @param parent
	 *            The parent composite
	 */
	protected void createLeftColumnControls(Composite parent)
	{
		Control control = createGenericInformation(parent, UiPluginResourceBundle.EDT_GENERAL_INFO);
		control.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING));
	}

	/**
	 * Create the right column controls for this form
	 * 
	 * @param parent
	 *            The parent composite
	 */
	protected void createRightColumnControls(Composite parent)
	{
		Control control = createTestCaseElementsSectionControl(parent, UiPluginResourceBundle.W_TST_CASES);
		control.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING));
	}

	
	/**
	 * Create the test case elements section
	 * 
	 * @param parent The parent composite
	 * @return Controls representing test cases section
	 */
	protected Control createTestCaseElementsSectionControl(Composite parent, String header)
	{
		FormToolkit toolkit = ((FormEditor) editor.getHyadesEditorPart()).getToolkit();
		
		Section section = FormUtil.createSection(toolkit, parent, getForm());
		
		Composite container = toolkit.createComposite(section);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		container.setLayout(gridLayout);
		container.setLayoutData(GridDataUtil.createFill());

		hyperlinkComposite = toolkit.createComposite(container);
		gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		gridLayout.verticalSpacing = 2;
		hyperlinkComposite.setLayout(gridLayout);
		hyperlinkComposite.setLayoutData(GridDataUtil.createFill());

		if (testcaseAdapter.getHyperLinkComposite() == null)
		{
			testcaseAdapter.setHyperLinkComposite(hyperlinkComposite);
		}
			
		
		
		Composite buttonContainer = toolkit.createComposite(container);
		buttonContainer.setLayoutData(new GridData(GridData.FILL_VERTICAL));
		gridLayout = new GridLayout();
		gridLayout.marginWidth = 0;
		gridLayout.marginHeight = 0;
		buttonContainer.setLayout(gridLayout);

		Button moreButton = toolkit.createButton(buttonContainer, UiPluginResourceBundle.ACT_MORE, SWT.PUSH); 
		moreButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END | GridData.VERTICAL_ALIGN_BEGINNING));
		moreButton.addSelectionListener(new SelectionAdapter()
		{
			public void widgetSelected(SelectionEvent e)
			{
				((FormEditor) editor.getHyadesEditorPart()).setActivePage(testCasesPageID);
			}
		});
		
		
		FormUtil.setSectionProperty (toolkit, section, container, header);
		
		return section;
	}

	
	/**
	 * Creates the generic information form section.
	 * 
	 * @param parent
	 * 			  The parent composite
	 * @param header
	 *            The title of the collapsible section
	 * @param description
	 *            The description of the section
	 * @return A collapsible section
	 */
	protected Control createGenericInformation(Composite parent, String header)
	{		
		FormToolkit toolkit = ((FormEditor) editor.getHyadesEditorPart()).getToolkit();
		
		sectionc = FormUtil.createSection(toolkit, parent, getForm());

		/* The name and the description text boxes */
		Composite sectionClient = addNorthControls(sectionc, toolkit);

		/* The center contorl - implemented by clients */
		sectionClient = addCenterControls(sectionc, sectionClient, toolkit);

		/* The type and the path controls */
		sectionClient = addSouthControls(sectionc, sectionClient, toolkit);

		FormUtil.setSectionProperty (toolkit, sectionc, sectionClient, header);

		return sectionc;
	}

	/**
	 * Used to create the name and description text boxes on the left hand side
	 * 
	 * @param parent
	 *            The parent composite.
	 * @param toolkit
	 *            The form toolkit
	 */
	protected Composite addNorthControls(Section parent, FormToolkit toolkit)
	{
		commonSection = new CommonSection(CommonSection.OVERVIEW);
		ITestSuite testSuite = getTestSuite();
		String name = (testSuite != null && testSuite.getName() != null ? testSuite.getName() : "");
		String desc = (testSuite != null && testSuite.getDescription() != null ? testSuite.getDescription() : "");		
		Composite composite = commonSection.createControl(editor, parent, toolkit, name, desc);		
		commonSection.setInput(testSuite);
		return composite;
	}

	/**
	 * The client should override this method to add controls between the north
	 * and the south controls
	 * 
	 * @param parent
	 *            The parent composite.
	 * @param sectionClient
	 *            The section client that is being build on.
	 * @param toolkit
	 *            The form toolkit
	 */
	protected Composite addCenterControls(Section parent, Composite sectionClient, FormToolkit toolkit)
	{
		return sectionClient;
	}

	/**
	 * Creates the type and path controls.
	 * 
	 * @param parent
	 *            The parent composite.
	 * @param sectionClient
	 *            The section client that is being build on.
	 * @param toolkit
	 *            The form toolkit
	 */
	protected Composite addSouthControls(Section parent, Composite sectionClient, FormToolkit toolkit)
	{
		return FormUtil.addSouthControls(getTestSuite(), parent, sectionClient, toolkit);
	}

	/**
	 * 
	 */
	public void updateTitle()
	{
		String title = getTestSuite().getName();
		if (title != null)
			((IHyadesEditorPartExtended) editor.getHyadesEditorPart()).setEditorTitle(title);
	}


	/**
	 * Returns the test suite
	 * 
	 * @return The test suite
	 */
    public ITestSuite getTestSuite() 
    {
		return super.getCommonTestSuite();
	}
    
	public void setActive(boolean active) 
	{
		super.setActive(active);
		if (active && testcaseAdapter != null)
		{
			testcaseAdapter.refreshComposite((EObject)getTestSuite());
			Section section = ((Section)hyperlinkComposite.getParent().getParent()); 
			
			/* Causes a refresh */
			section.setExpanded(false);
			section.setExpanded(true);
		}
	}
}
