/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCasesEclipseForm.java,v 1.8 2007/04/26 20:07:47 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.tools.ui.common.internal.util.FormUtil;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.tools.ui.common.internal.util.FormUtil.CommonSection;
import org.eclipse.hyades.test.ui.internal.editor.form.base.StructuredViewerPart;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailPropertiesSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailsPageProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EObjectTree;
import org.eclipse.hyades.test.ui.internal.editor.form.util.EditorEclipseForm;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IEditorExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;


/**
 * This class was created in response to the deprecated APIs about the way that
 * forms are currently handled.
 * 
 * <p>
 * This class represents the test case form that appears in the multi-page test
 * suite editor
 * </p>
 * 
 * @author Ali Mehregani & marcelop
 */
public class TestCasesEclipseForm extends EditorEclipseForm
implements IITestSuiteProvider, ISelectionChangedListener
{
	
	/* Help indices */
	protected static final int HELP_NAMED_ELEMENT_CONTROL = 1;
	protected static final int HELP_TEST_CASES_SECTION_CONTROL = 2;
	protected static final int HELP_TEST_CASES_SECTION_TREE_CONTROL = 3;
	protected static final int HELP_DETAIL_SECTION_CONTROL = 4;
	
	/* The form editor that this form is apart of */
	private IEditorExtension editor;

	/* The eclipse form representing this form */
	private ScrolledForm form;
		
	/* The test case tree */
	private EObjectTree eobjectTree;
	
	/* The common section */
	private Section sectionc;
	private CommonSection commonSection;
	
	/* The details section */
	private Section sectiond;
	private DetailPropertiesSection propertySection;
	
	/* Stores the first element of a selection */
	private ITestCase currentSelection;
	
	
	/**
	 * The constructor
	 * 
	 * @param editor
	 *            The form editor that this form is apart of
	 * @param id
	 *            The id of the form
	 * @param title
	 *            The title of the form
	 */
	public TestCasesEclipseForm(IEditorExtension editor, String editorTitle, String id, String title)
	{
		super(editor, editorTitle, id, title);
		this.editor = editor;
	}

	
	/**
	 * @see org.eclipse.update.ui.forms.internal.IForm#dispose()
	 */
	public void dispose()
	{
		/* Clean up here */
		
		if (eobjectTree != null)
		{
			eobjectTree.dispose();
			eobjectTree = null;
		}

		if (form != null)
		{
			form.dispose();
			form = null;
		}
		
		if (sectionc != null)
		{
			sectionc.dispose();
			sectionc = null;
		}
		
		if (commonSection != null)
		{
			commonSection.dispose();
			commonSection = null;
		}
		
		if (sectiond != null)
		{
			sectiond.dispose();
			sectiond = null;
		}
		
		if (propertySection != null)
		{
			propertySection.dispose();
			propertySection = null;
		}
		
		super.dispose();
	}
	
	protected void createFormContent(IManagedForm managedForm)
	{
		form = managedForm.getForm();
		super.createFormContent(managedForm);		
	}
	
	
	/**
	 * Create the left column controls for this form
	 * 
	 * @param parent
	 *            The parent composite
	 */
	protected void createLeftColumnControls(Composite parent)
	{
		Control control = createTestCaseSection(parent, UiPluginResourceBundle.W_TST_CASES);
		control.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
	}
	
	
	/**
	 * Create the left column controls for this form
	 * 
	 * @param parent
	 *            The parent composite
	 */
	protected Control createTestCaseSection(Composite parent, String header)
	{	
		/* Create the section */		
		FormToolkit toolkit = ((FormEditor)editor.getHyadesEditorPart()).getToolkit();		
		Section section = FormUtil.createSection(toolkit, parent, form);
		
		/* Create the client of the section */ 
		eobjectTree = new EObjectTree (editor, Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases(), getAddTestCaseAction());
		addCustomButtons();
		Composite sectionClient = eobjectTree.createControls(section, toolkit);
		buttonsCreated();
		setStandardControlIndices();
		
		eobjectTree.getViewerPart().getViewer().setInput(getTestSuite());
		eobjectTree.getTreeViewer().addSelectionChangedListener(this);
		
		/* The button are all suppose to initially be disabled, except for add */		
		toggleStdButtonEnableStatus(0, 0, true);
		toggleStdButtonEnableStatus(1, 3, false);
		
		/* Set the properties of the section */
		FormUtil.setSectionProperty (toolkit, section, sectionClient, header);
		
		registerHelp(HELP_TEST_CASES_SECTION_CONTROL, section);
		registerHelp(HELP_TEST_CASES_SECTION_TREE_CONTROL, eobjectTree.getTreeViewer().getControl());
		
		return section;
		
	}

	
	/**
	 * Returns an array indicating the indices of the standard buttons.  The indices are
	 * expected to be in this order: {Add button, Remove button, Up button, Down button}
	 * 
	 * @return An int array, indicating the indices of the standard buttons.
	 */
	protected int[] getStanderdControlIndices()
	{
		return eobjectTree.getButtonIndices();
	}
	
	
	/**
	 * Set the button indices of the standard buttons.  The button indices are expected to be 
	 * in this format {Add button, Remove button, Up button, Down button}
	 * 
	 * @param indices The indices of the standard button
	 */
	protected void setStandardControlIndices()
	{
		eobjectTree.setButtonIndices(new int[] {0,1,2,3});
	}


	/**
	 * Clients have the option of over writing this method
	 * Overwriting this method requires clients to also overwrite the setStandardControlIndices() 
	 * (if the standard control indices are changed) method in order for the right index to be retrieved.
	 * 
	 */
	protected void addCustomButtons ()
	{
		
	}
	

	/**
	 * Invoked after button controls have been created.  Clients can
	 * overwrite this method to be notified of when the buttons have
	 * been created.
	 */
	protected void buttonsCreated ()
	{
		
	}
	protected void createRightColumnControls(Composite parent)
	{
		FormToolkit toolkit = ((FormEditor)editor.getHyadesEditorPart()).getToolkit();
		Control commonPropertySection = createCommonPropertySection (toolkit, parent);
		propertySection = new DetailPropertiesSection (editor, this, toolkit);
		Control detailSection = createDetailPropertySection(toolkit, parent);
		
		if (detailSection != null)
			detailSection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		commonPropertySection.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false));
	}


    /**
     * Create thje common property section on the right hand side of the 
     * behavior form
     * 
     * @param toolkit The forms toolkit
     * @param parent The parent composite
     */
    protected Section createCommonPropertySection (FormToolkit toolkit, Composite parent)
    {
    	sectionc = FormUtil.createSection(toolkit, parent, form);

		/* The name and the description text boxes */
    	commonSection = new CommonSection(CommonSection.TEST_CASES);
		Composite sectionClient = commonSection.createControl(editor, sectionc, toolkit, "", "");

		FormUtil.setSectionProperty (toolkit, sectionc, sectionClient, UiPluginResourceBundle.EDT_GENERAL_INFO);

		return sectionc;    	
    }

    
    /**
     * Create the detail property section on the right hand side of the 
     * behavior form
     * 
     * @param parent The parent composite
     * @param header The header of the section
     * @param desc The description of the section
     */
    protected Control createDetailPropertySection (FormToolkit toolkit, Composite parent)
    {
		DetailsPageProvider detailPageProvider = new DetailsPageProvider();
		addDetails(detailPageProvider);	

		sectiond = FormUtil.createSection(toolkit, parent, form);	
		Control sectionClient = propertySection.createDefaultControl(sectiond);
		propertySection.setDetailPageProvider(detailPageProvider);
		
		FormUtil.setSectionProperty (toolkit, sectiond, sectionClient, UiPluginResourceBundle.W_DETAIL);
		
		return sectiond;
	
    }
    
    
	/**
	 * Required to be over-written by the client
	 * 
	 * @param flag The help flag
	 * @param control The control for which a help is created for
	 */
	protected void registerHelp(int flag, Control control)
	{
	}
	
	
	/**
	 * Returns the add action.  Expected to be over written by the client.
	 * 
	 * @return The add action
	 */
	protected IAction getAddTestCaseAction()
	{
		return null;
	}


	/**
	 * Returns the test suite 
	 * 
	 * @return The test suite
	 */
    public ITestSuite getTestSuite()
    {
		return super.getCommonTestSuite();
	}

    

    /**
     * Invoked when the selection of the tree showing the test cases have changed.
     * Take this opportunity to update the common and the details section
     */
	public void selectionChanged(SelectionChangedEvent event) 
	{
		if(event.getSource() == eobjectTree.getTreeViewer())
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)eobjectTree.getTreeViewer().getSelection();
			Object selection = structuredSelection.getFirstElement();
			
			if (selection instanceof ITestCase)
			{
				currentSelection = (ITestCase) selection;
				commonSection.setInput(currentSelection);
			}
			else
				currentSelection = null;
			if(propertySection != null)
				propertySection.setInput(structuredSelection);
		}
		else		
			currentSelection = null;
		
		/* Disable the standard buttons if there are no selections */
		if (currentSelection == null)
		{
			toggleStdButtonEnableStatus (0, 0, true);
			toggleStdButtonEnableStatus (1, 3, false);	
		}
		
	}


	protected void toggleEnableStatus(int start, int end, boolean isEnabled) 
	{
		StructuredViewerPart viewerPart = eobjectTree.getViewerPart();
		
		for (int i = start; i <= end; i++)
			viewerPart.setButtonEnabled(i, isEnabled);
	}
	
	
	protected void toggleEnableStatus(boolean[] enableStatus) 
	{
		StructuredViewerPart viewerPart = eobjectTree.getViewerPart();
		
		for (int i = 0; i < enableStatus.length; i++)
			viewerPart.setButtonEnabled(i, enableStatus[i]);
	}
	
	protected void toggleStdButtonEnableStatus (int start, int end, boolean isEnabled)
	{
		int[] indices = getStanderdControlIndices();
		StructuredViewerPart viewerPart = eobjectTree.getViewerPart();
		
		for (int i = start; i <= end; i++)
			viewerPart.setButtonEnabled(indices[i], isEnabled);
		
	}
	protected boolean[] getEnableStatus(int start, int end)
	{
		boolean[] enableStatus = new boolean[end - start + 1];
		StructuredViewerPart viewerPart = eobjectTree.getViewerPart();
		
		for (int i = start; i <= end; i++)
		{
			Button b =  viewerPart.getButton(i);
			if (b != null)
				enableStatus[i] = b.getEnabled();
			else
				enableStatus[i] = false;
		}
		
		return enableStatus;
	}


	public EObjectTree getEobjectTree()
	{
		return eobjectTree;
	}
    
	public ITestCase getCurrentSelection()
	{
		return currentSelection;
	}


	/**
	 * @return the commonSection
	 */
	public CommonSection getCommonSection()
	{
		return commonSection;
	}

}
