/********************************************************************** 
 * Copyright (c) 2005, 2008 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id$ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;

/**
 * EMF Adapter installed on IBlock (BVRInteraction) in the reload method of the test suite editor extension.
 * The adapter is in charge of cleaning invocation of deleted test elements.
 * Adding/removing invocation into the BVRInteraction install/uninstall this adapter in the ITestInvocation (BVRExecutionOccurrence).
 * If the invoked test of the invocation element is set to null (due to its deletion) then the invocation is removed. 
 *  
 * @author  Jerome Gout
 * @author  Paul E. Slauenwhite
 * @version January 8, 2008
 * @since   December 21, 2005
 */
public class TestInvocationCleaner extends AdapterImpl {

    public void notifyChanged(Notification msg) {
        if(msg.getNotifier() instanceof BVRInteraction) {
            if(msg.getFeatureID(BVRInteraction.class) == Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS) {
                //- this notification is related to an action, check if it is really an invocation and if it is an ADD/REMOVE
                switch (msg.getEventType()) {
                    case Notification.ADD:
                    case Notification.ADD_MANY:
                        installCleanerInInvocation(msg.getNewValue());
                        break;
                    case Notification.REMOVE:
                    case Notification.REMOVE_MANY:
                        uninstallCleanerInInvocation(msg.getOldValue());
                        break;
                }
            }
        } else 
        if (msg.getNotifier() instanceof BVRExecutionOccurrence) {
            if(msg.getFeatureID(BVRExecutionOccurrence.class) == Common_Behavior_InteractionsPackage.BVR_EXECUTION_OCCURRENCE__OTHER_BEHAVIOR) {
                //- if the test element invoked by the invocation is set to null
                switch (msg.getEventType()) {
                    case Notification.SET:
                        if(msg.getNewValue() == null) {
                            //- remove itself from its parent
                            ((BVRExecutionOccurrence)msg.getNotifier()).setInteraction(null);
                        }
                        break;
                }
            }
        }
    }
    
    private void installCleanerInInvocation(Object newValue) {
        //- only install this on an test invocation element (BVRExecutionOccurrence)
        if (newValue instanceof BVRExecutionOccurrence) {
            BVRExecutionOccurrence invoc = (BVRExecutionOccurrence) newValue;
            invoc.eAdapters().add(this);
        }
    }

    private void uninstallCleanerInInvocation(Object oldValue) {
        if (oldValue instanceof BVRExecutionOccurrence) {
            BVRExecutionOccurrence invoc = (BVRExecutionOccurrence) oldValue;
            invoc.eAdapters().remove(this);
        } 
    }
}
