/*******************************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestInvocationDetailForm.java,v 1.5 2008/04/16 18:11:01 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.ui.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.tools.ui.common.internal.util.FormUtil;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIImages;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.hyades.test.ui.internal.editor.form.util.AbstractDetailForm;
import org.eclipse.hyades.test.ui.internal.editor.form.util.IDetailPageContext;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.model.IWorkbenchAdapter;

/**
 * Replaces org.eclipse.hyades.test.tools.ui.common.internal.editor.TestInvocationDetailPage to be able
 * to use Eclipse Form APIs.
 * <p/>
 * 
 * 
 * @author  Ali Mehregani
 * @author  Paul E. Slauenwhite
 * @author  Marcelo Paternostro
 * @version April 16, 2008
 * @since   August 19, 2005
 */
public abstract class TestInvocationDetailForm extends AbstractDetailForm 
implements SelectionListener
{
	protected static final int HELP_PAGE_CONTROL = 1;
	protected static final int HELP_SYNCHRONOUS_CONTROL = 2;
	protected static final int HELP_FILE_CONTROL = 3;
	protected static final int HELP_EDIT_CONTROL = 4;
	protected static final int HELP_TYPE_CONTROL = 5;

	private Button synchronousButton;

	private Label imageLabel;
	
	private Text typeText;
	private Text fileText;
	private Button editButton;
	private Hyperlink testLink;
	
	private ITestInvocation testInvocation;
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		if((testLink != null) && (!testLink.isDisposed()))
			testLink.setData(null);
		testInvocation = null;
	}

	/**
	 * @see org.eclipse.hyades.test.ui.editor.form.util.AbstractDetailPage#createControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Control createControl(Composite parent, FormToolkit widgetFactory, IDetailPageContext context)
	{
		this.context = context;
		Composite composite = widgetFactory.createComposite(parent);
		composite.setLayout(new GridLayout());
		GridData compositeGD = new GridData();
		composite.setLayoutData(compositeGD);

		synchronousButton = widgetFactory.createButton(composite, getSynchronousLabel(), SWT.CHECK);
		synchronousButton.setLayoutData(GridDataUtil.createHorizontalFill());

		createTestLink(composite);

		registerHelp(HELP_PAGE_CONTROL, composite);				
		registerHelp(HELP_PAGE_CONTROL, synchronousButton);				
		registerHelp(HELP_PAGE_CONTROL, fileText);				
		registerHelp(HELP_PAGE_CONTROL, editButton);				
		registerHelp(HELP_PAGE_CONTROL, typeText);				

		return composite;
	}
	
	
	abstract protected String getSynchronousLabel();

	
	protected void registerHelp(int flag, Object object)
	{
	}
	
	
	protected void createTestLink(Composite parent)
	{
		FormToolkit widgetFactory = getEditorForm().getEditor().getToolkit();
		
		Composite composite = widgetFactory.createComposite(parent);
		GridLayout gridLayout = new GridLayout();
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		composite.setLayout(gridLayout);
		composite.setLayoutData(GridDataUtil.createHorizontalFill());
		
		Composite linkComposite = widgetFactory.createComposite(composite);
		gridLayout = new GridLayout(3, false);
		gridLayout.marginHeight = 0;
		gridLayout.marginWidth = 0;
		linkComposite.setLayout(gridLayout);
		linkComposite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

        imageLabel = widgetFactory.createLabel(linkComposite, "");
		imageLabel.setImage(TestUIImages.INSTANCE.getImage(TestUIImages.IMG_ERROR));
        
        Composite c1 = widgetFactory.createComposite(linkComposite);
        c1.setLayout(new GridLayout());
        c1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL|GridData.GRAB_HORIZONTAL));
        
		testLink = widgetFactory.createHyperlink(c1, "", SWT.WRAP);
		testLink.setText(getDefaultLinkText());
		testLink.setToolTipText(getDefaultLinkToolTip()); 
        GridData testLinkGD = new GridData();
        testLinkGD.grabExcessHorizontalSpace = true;
        testLinkGD.horizontalAlignment = SWT.FILL;		
		testLink.setLayoutData(testLinkGD);
        
        testLink.addHyperlinkListener(new TestCaseLinkListener());

        editButton = widgetFactory.createButton(linkComposite, UiPluginResourceBundle.label_Update, SWT.PUSH);
        editButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_END));
        
        Text[] typeAndFile = FormUtil.createTypeFileControls(null, null, composite, widgetFactory);
        if (typeAndFile != null && typeAndFile.length >= 2)
        {
        	typeText = typeAndFile[0];
        	fileText = typeAndFile[1];
        }
        
	}
	
	protected String getDefaultLinkText()
	{
		return "unspecified";
	}

	protected String getDefaultLinkToolTip()
	{
		return "";
	}
	
	

	/**
	 * 
	 */
	public void setInput(Object object)
	{
		testInvocation = null;
		if (synchronousButton != null)
			synchronousButton.removeSelectionListener(this);
		
		editButton.removeSelectionListener(this);

		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}

		boolean doPack = false;
		boolean testIsSet = false;
		if(object instanceof ITestInvocation)
		{
			testInvocation = (ITestInvocation)object;
			ITest test = testInvocation.getInvokedTest();
			doPack = true;
			
			editButton.setEnabled(true);
			if (synchronousButton != null)
			{
				synchronousButton.setSelection(testInvocation.isSynchronous());
				synchronousButton.setEnabled(true);
			}

			if(test != null)
			{		
				testIsSet = true;
				
				ImageDescriptor imageDescriptor = null;
				if(test instanceof IAdaptable)
				{
					IWorkbenchAdapter workbenchAdapter = (IWorkbenchAdapter)((IAdaptable)test).getAdapter(IWorkbenchAdapter.class);
					if((workbenchAdapter != null))
						imageDescriptor = workbenchAdapter.getImageDescriptor(test);
				}
				if(imageDescriptor == null)
					imageDescriptor = TestUIImages.INSTANCE.getImageDescriptor(TestUIImages.IMG_DEFAULT);

				imageLabel.setImage(imageDescriptor.createImage());
				
				if(test.getName() != null)
					testLink.setText(test.getName());
				else
					testLink.setText(ToolsUiPluginResourceBundle.W_TEST);
				testLink.setData(test);
				
				String value = test.getType();
				if(value != null)
				{
					IAssociationDescriptor descriptor = null;
					if(test instanceof ITestSuite)
						descriptor = TestUIExtension.getTestSuiteMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS).getDefaultAssociationDescriptor(value);
					else if(test instanceof ITestCase)
						descriptor = TestUIExtension.getTestCaseMappingRegistry().getAssociationMapping(HyadesUIPlugin.EP_TYPE_DESCRIPTIONS).getDefaultAssociationDescriptor(value);
						
					if((descriptor != null) && (descriptor.getName() != null))
						value = descriptor.getName();
					typeText.setText(value);
				}
					
				fileText.setText(EMFUtil.getFilePath((EObject)test));
			}						
		}
		else
		{
			editButton.setEnabled(false);
		}
		
		if(!testIsSet)
		{
			doPack = true;
			imageLabel.setImage(TestUIImages.INSTANCE.getImage(TestUIImages.IMG_ERROR));
			testLink.setText(getDefaultLinkText());
			testLink.setData(null);
			fileText.setText("");
			typeText.setText("");
			if (synchronousButton != null)
				synchronousButton.setEnabled(false);
		}
		
		if(doPack)
		{
			imageLabel.pack(true);
			imageLabel.redraw();
			testLink.pack(true);
			testLink.redraw();			
		}
		
		editButton.addSelectionListener(this);
		if (synchronousButton != null)
			synchronousButton.addSelectionListener(this);
	}

	/**
	 * 
	 */
	public Object getInput()
	{
		return testInvocation;
	}

	/**
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e)
	{
		e.doit = !isReadOnly();
	}

	/**
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e)
	{
		if(isReadOnly())
		{
			e.doit = false;
		}
		else
		{
			if(e.widget == editButton)
			{
				ITestSuite testSuite = (ITestSuite)EcoreUtil.getRootContainer((EObject)testInvocation);
				InvokedTestSelectionDialog selectionDialog = createInvokedTestSelectionDialog(testSuite);
				selectionDialog.setTest((ITest)testLink.getData());
				if(selectionDialog.open() == IDialogConstants.OK_ID)
				{
					ITest test = (ITest)selectionDialog.getTests().iterator().next();
					ResourceSet resourceSet = ((EObject)testSuite).eResource().getResourceSet();
					test = (ITest)EMFUtil.getEObject(resourceSet, (EObject)test, true);
					
					if(testInvocation.getInvokedTest() != test)
					{
						testInvocation.setInvokedTest(test);			
						setInput(testInvocation);
					}
				}
			}
			
			else if(e.widget == synchronousButton)
			{
				testInvocation.setSynchronous(synchronousButton.getSelection());
				if (getEditorForm().getFormEditor() instanceof BaseEditorExtension)
					((BaseEditorExtension)getEditorForm().getFormEditor()).markDirty();
			}
		}			
	}
	
	abstract protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite);
	
	public void verifyText(VerifyEvent e)
	{
		
	}
	
	
	/**
	 * The hyper link listener used for test case hyper links.
	 */
	private class TestCaseLinkListener implements IHyperlinkListener
	{

		public void linkActivated(HyperlinkEvent event)
		{
			Object data = event.widget.getData();
			if(data != null)
			{
				EObject eObject = (EObject)data;
				IEditorPart editorPart = TestUIUtil.openEditor(eObject.eResource(), null, false);
				if(editorPart instanceof ISelectionProvider)
					((ISelectionProvider)editorPart).setSelection(new StructuredSelection(eObject));
				
				return;
			}
			
			if (getEditorForm().getFormEditor() instanceof BaseEditorExtension)
			{
				BaseEditorExtension baseEditor = (BaseEditorExtension)getEditorForm().getFormEditor();
				IActionBars actionBars = baseEditor.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
				IStatusLineManager manager = actionBars.getStatusLineManager();
				if (manager != null)
					manager.setErrorMessage(UiPluginResourceBundle._ERROR_MSG_UN_OPEN_OBJ);	
			}
				

		}

		/**
		 * 
		 */
		public void linkEntered(HyperlinkEvent event)
		{
			if (getEditorForm().getFormEditor() instanceof BaseEditorExtension)
			{
				BaseEditorExtension baseEditor = (BaseEditorExtension)getEditorForm().getFormEditor();
				
				IActionBars actionBars = baseEditor.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
				IStatusLineManager manager = actionBars.getStatusLineManager();
				if (manager != null)
					manager.setMessage(((Hyperlink)event.widget).getText());
			}
		}

		/**
		 * 
		 */
		public void linkExited(HyperlinkEvent event)
		{
			if (getEditorForm().getFormEditor() instanceof BaseEditorExtension)
			{
				BaseEditorExtension baseEditor = (BaseEditorExtension)getEditorForm().getFormEditor();
				IActionBars actionBars = baseEditor.getHyadesEditorPart().getEditorPart().getEditorSite().getActionBars();
				IStatusLineManager manager = actionBars.getStatusLineManager();
				if (manager != null)
				{
					manager.setMessage("");
					manager.setErrorMessage("");
				}
			}
		}
		
	}
	

}
