/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestSuiteEditorExt.java,v 1.5 2007/05/02 19:36:06 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.test.tools.ui.common.internal.editor;

import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.editor.extension.BaseEditorExtension;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

/**
 * Created in response of TestSuiteEditorExtension's deprecation
 * 
 * @author Ali Mehregani and marcelop
 */
abstract public class TestSuiteEditorExt extends 
BaseEditorExtension
{
	protected static final int PAGE_OVERVIEW = 0;
	protected static final int PAGE_TEST_CASES = 1;
	protected static final int PAGE_BEHAVIOR = 2;
	
	/* The three standard pages */
	private OverviewEclipseForm overviewForm;
	private TestCasesEclipseForm testCasesForm;
	private BehaviorEclipseForm behaviorForm;
	
	/**
	 * Returns the test case suite manipulated by this form.
	 * 
	 * @return The model that we modified
	 */
	public ITestSuite getTestSuite() 
	{
		return (TPFTestSuite)getHyadesEditorPart().getEditorObject();
	}

	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		getOverviewForm().dispose();
		getTestCasesForm().dispose();
		getBehaviorForm().dispose();
		
		super.dispose();
	}

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#getSelection()
	 */
	public IStructuredSelection getSelection()
	{
		switch(getHyadesEditorPart().getActivePage())
		{
			case PAGE_OVERVIEW:
				return new StructuredSelection(getTestSuite());
				
			
			case PAGE_TEST_CASES:
				if (getTestCasesForm() != null && getTestCasesForm().getEobjectTree() != null)
					return getTestCasesForm().getEobjectTree().getStructuredSelection();

          case PAGE_BEHAVIOR:
				if (getBehaviorForm() != null && getBehaviorForm().getBehaviourObjectTree() != null)
					return getBehaviorForm().getBehaviourObjectTree().getStructuredSelection();
		}
		
		return StructuredSelection.EMPTY;
	}
	
	
	protected void setOverviewForm(OverviewEclipseForm testSuiteForm)
	{
		this.overviewForm = testSuiteForm;
	}
	
	
	protected OverviewEclipseForm getOverviewForm()
	{
		return overviewForm;
	}
	
	protected void setTestCasesForm(TestCasesEclipseForm testCasesForm)
	{
		this.testCasesForm = testCasesForm;
	}

	protected TestCasesEclipseForm getTestCasesForm()
	{
		return testCasesForm;
	}

	protected void setBehaviorForm(BehaviorEclipseForm behaviorForm)
	{
		this.behaviorForm = behaviorForm;
	}

	protected BehaviorEclipseForm getBehaviorForm()
	{
		return behaviorForm;
	}

	
	
	/**
	 * @see org.eclipse.hyades.ui.util.IRefreshable#refreshContent(java.lang.Object)
	 */
	public void refreshContent(Object data)
	{
		getOverviewForm().updateTitle();
	}
	
	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#pageActivated(int)
	 */
	public boolean pageActivated(int index)
	{	
		switch(index)
		{
			case PAGE_OVERVIEW:				
				return getOverviewForm().activated();
				
			case PAGE_TEST_CASES:
				return getTestCasesForm().activated();

			case PAGE_BEHAVIOR:
				return getBehaviorForm().activated();
		}
		
		return false;

	}
}
