/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddTestCase.java,v 1.7 2007/03/22 14:42:46 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.editor.action;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.tools.core.common.util.TestCommonUtil;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.util.IDisposable;
import org.eclipse.jface.action.Action;

/**
 * Adds a loop to the block.
 * @author marcelop
 * @since 0.3.0
 */
public class AddTestCase 
extends Action implements IDisposable
{
	private IITestSuiteProvider testSuiteProvider;
	private String type;
	private String baseName;
	private boolean actionPerformed;
	
	/**
	 * Constructor for AddTestMethod
	 */
	public AddTestCase(IITestSuiteProvider testSuiteProvider, String type, String baseName)
	{
		super(UiPluginResourceBundle.LBL_ADD);
		this.testSuiteProvider = testSuiteProvider;
		this.type = type;
		this.baseName = baseName;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.util.IDisposable#dispose()
	 */
	public void dispose()
	{
		testSuiteProvider = null;
	}
	
	public boolean actionPerformed()
	{
		return actionPerformed;
	}
	
	protected void setActionPerformed(boolean actionPerformed)
	{
		this.actionPerformed = actionPerformed;
	}

	protected ITestSuite getTestSuite()
	{
		return testSuiteProvider.getTestSuite();
	}
	
	public String getType()
	{
		return type;
	}

	public String getBaseName()
	{
		return baseName;
	}

	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);
		ITestSuite testSuite = getTestSuite();
		boolean isExternalBehavior = testSuite.getImplementor().isExternalImplementor();
		adjusTestCase(TestCommonUtil.createTestCase(testSuite, getType(), isExternalBehavior, TestCommonUtil.getUniqueName(getBaseName(),  testSuite.getITestCases())));
		setActionPerformed(true);
	}
	
	protected void adjusTestCase(ITestCase testCase)
	{
	}
}