/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AddTestInvocation.java,v 1.17 2009/04/17 00:47:32 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.editor.action;

import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.core.common.util.TestCommonUtil;
import org.eclipse.hyades.test.tools.ui.common.TestCommonImages;
import org.eclipse.hyades.test.tools.ui.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.jface.dialogs.IDialogConstants;

/**
 * <p>Abstract action class to add a test invocation to a block.</p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @version April 16, 2009
 * @since   February 1, 2005
 */
abstract public class AddTestInvocation 
extends AddBlockChildAction
{
	/**
	 * Constructor for AddTestMethod
	 */
	public AddTestInvocation(IITestSuiteProvider testSuiteProvider, String baseName)
	{
		super(testSuiteProvider, ToolsUiPluginResourceBundle.LBL_INV, baseName);
		setImageDescriptor(TestCommonImages.INSTANCE.getImageDescriptor(TestCommonImages.IMG_INVOCATION));
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);

		InvokedTestSelectionDialog selectionDialog = createInvokedTestSelectionDialog(getTestSuite());
		if(selectionDialog.open() == IDialogConstants.OK_ID)
		{
			for (Iterator i = selectionDialog.getTests().iterator(); i.hasNext();)
			{
				ITest test = (ITest)i.next();
				ResourceSet resourceSet = ((EObject)getTestSuite()).eResource().getResourceSet();
				test = (ITest)EMFUtil.getEObject(resourceSet, (EObject)test, true);
	
				ITestInvocation testInvocation = HyadesFactory.INSTANCE.createTestInvocation(test);
				testInvocation.setName(calculateName(test));
				getBlock().getActions().add(testInvocation);
			}
			setActionPerformed(true);
		}
	}
	
	abstract protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite);
	
	protected String calculateName(ITest test)
	{
		String testName = test.getName();
		if(testName == null)
			return TestCommonUtil.getUniqueName(getBaseName(), getBlock().getActions());
			
		if(test instanceof ITestCase)
		{
			ITestSuite invokedTestSuite = ((ITestCase)test).getOwner();
			if(getTestSuite() != invokedTestSuite)
			{ 
				String testSuiteName = invokedTestSuite.getName();
				if(testSuiteName != null)
					testName = testSuiteName + "." + testName;
			} 
		}
		
		return (testName.concat(" - ").concat(getBaseName()));
	}
}
