/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: BehaviorActionGroup.java,v 1.3 2007/04/19 18:31:43 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.editor.action;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.ui.internal.util.CoreUtil;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.SelectionListenerAction;

/**
 * Creation group action for the Test Navigator.
 * <p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @version March 14, 2007
 * @since   February 1, 2005
 * @since   1.0.2
 */
public class BehaviorActionGroup 
extends ActionGroup
{
	private IITestSuiteProvider testSuiteProvider;	
	protected List actions;
	String menuLabel;
	
	/**
	 * Constructor for BehaviorActionGroup
	 * @param testSuiteProvider
	 * @param menuLabel If this group is to be created as a menu, label of this menu.
	 * This argument will not be used otherwise.
	 */
	public BehaviorActionGroup(IITestSuiteProvider testSuiteProvider, String menuLabel)
	{
		super();
		this.testSuiteProvider = testSuiteProvider;
		actions = new ArrayList();
		this.menuLabel = menuLabel;
	}

	/**
	 * @see org.eclipse.ui.actions.ActionGroup#dispose()
	 */
	public void dispose()
	{
		CoreUtil.dispose(actions);
		testSuiteProvider = null;
		
		super.dispose();
	}
	
	public void addAction(SelectionListenerAction selectionListenerAction)
	{
		actions.add(selectionListenerAction);
	}

	public void removeAction(SelectionListenerAction selectionListenerAction)
	{
		actions.remove(selectionListenerAction);
	}

	public void clearActions()
	{
		actions.clear();
	}

	/**
	 * @see org.eclipse.ui.actions.ActionGroup#fillContextMenu(org.eclipse.jface.action.IMenuManager)
	 */
	public void fillContextMenu(IMenuManager menuManager)
	{
		fillContextMenu(menuManager, true);
	}
	
	public void fillContextMenu(IMenuManager menuManager, boolean createSubMenu)
	{
		if(actions.isEmpty())
			return;
			
		adjustContext();
		
		IMenuManager addMenu = null;
		if(createSubMenu)
		{
			addMenu = new MenuManager(menuLabel);
			menuManager.add(addMenu);
		}
		else
			addMenu = menuManager;
		
		for(Iterator i = actions.iterator(); i.hasNext();)
			addMenu.add((IAction)i.next());
	}
	
	public void fillContextMenu(Menu menu, boolean clearMenu)
	{		
		if(clearMenu)
		{
			MenuItem[] menuItems = menu.getItems();
			for (int i = 0, maxi = menuItems.length; i < maxi; i++)
				menuItems[i].dispose();
		}

		if(actions.isEmpty())
			return;

		adjustContext();
		
		int count = 0;
		for(Iterator i = actions.iterator(); i.hasNext();)
			new ActionContributionItem((IAction)i.next()).fill(menu, count++);
	}
	
	protected void adjustContext()
	{
		IStructuredSelection structuredSelection = null;
		if(getContext() != null)
			structuredSelection = (IStructuredSelection)getContext().getSelection();
		
		//Note: If the selection was the result of setting the input during initialization of the 
		//org.eclipse.hyades.test.tools.ui.common.internal.editor.BehaviorForm (e.g. load() method) 
		//and the result of a) a button selection or b) a tree selection in the 
		//org.eclipse.hyades.test.tools.ui.common.internal.editor.BehaviorSection, create a new selection
		//with the test suite.
		if((structuredSelection == null) || structuredSelection.isEmpty() || !(structuredSelection instanceof TreeSelection)){
			structuredSelection = new StructuredSelection(testSuiteProvider.getTestSuite());
		}
			
		for(Iterator i = actions.iterator(); i.hasNext();)
			((SelectionListenerAction)i.next()).selectionChanged(structuredSelection);
	}
	
	/**
	 * Disable the actions until the next invocation of one of the
	 * fill context menu actions.
	 */
	public void disableActions()
	{
		for(Iterator i = actions.iterator(); i.hasNext();)
			((IAction)i.next()).setEnabled(false);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.actions.ActionGroup#setContext(org.eclipse.ui.actions.ActionContext)
	 */
	public void setContext(ActionContext context) {
		super.setContext(context);
		if (context != null) {
			adjustContext();
		}
	}
	
	public boolean isEnabled() {
		Iterator it = actions.iterator();
		while (it.hasNext()) {
			SelectionListenerAction action = (SelectionListenerAction) it.next();
			if (!action.isEnabled()) return false;
		}
		return true;
	}

}
