/********************************************************************** 
 * Copyright (c) 2005, 2006 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html         
 * $Id: InsertBlockChildAction.java,v 1.3 2006/01/20 15:36:55 mddunn Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.tools.ui.common.internal.editor.action;

import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * @author CERVILLA
 *
 */
public class InsertBlockChildAction extends AddBlockChildAction {

	/**
	 * @param testSuiteProvider
	 * @param text
	 * @param baseName
	 */
	public InsertBlockChildAction(IITestSuiteProvider testSuiteProvider,
			String text, String baseName) {
		super(testSuiteProvider, text, baseName);
	}
	
	/*
	 * @see org.eclipse.ui.actions.SelectionListenerAction#updateSelection(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	protected boolean updateSelection(IStructuredSelection structuredSelection)
	{
		if(structuredSelection.size() != 1)
			return false;
			
		Object object = structuredSelection.getFirstElement();
		if (object instanceof ITestSuite) {
			return false;
		}
		if(object instanceof ITestInvocation)
		{
			return true;
		}
		return super.updateSelection(structuredSelection);
	}	
}
