/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InsertTestInvocation.java,v 1.11 2009/09/29 20:10:37 bjerome Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.editor.action;

import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestInvocation;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.core.util.EMFUtil;
import org.eclipse.hyades.test.tools.core.common.util.TestCommonUtil;
import org.eclipse.hyades.test.tools.ui.common.TestCommonImages;
import org.eclipse.hyades.test.tools.ui.common.internal.dialog.InvokedTestSelectionDialog;
import org.eclipse.hyades.test.tools.ui.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.jface.dialogs.IDialogConstants;

/**
 * <p>Abstract action class to insert a test invocation in a block.</p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @author	Jerome Bozier
 * @version September 28, 2009
 * @since   March 18, 2005
 */
abstract public class InsertTestInvocation 
extends InsertBlockChildAction
{
	
	/**
	 * Constructor for AddTestMethod
	 */
	public InsertTestInvocation(IITestSuiteProvider testSuiteProvider, String baseName)
	{
		super(testSuiteProvider, ToolsUiPluginResourceBundle.LBL_INV, baseName); 
		setImageDescriptor(TestCommonImages.INSTANCE.getImageDescriptor(TestCommonImages.IMG_INVOCATION));
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		setActionPerformed(false);

		InvokedTestSelectionDialog selectionDialog = createInvokedTestSelectionDialog(getTestSuite());
		if(selectionDialog.open() == IDialogConstants.OK_ID)
		{
			IBlock parentBlock = null;
			// Find the parent block of the selection
			EObject objectSelection = (EObject)getStructuredSelection().getFirstElement();
			EObject parent = objectSelection.eContainer();
			if (parent != null && parent instanceof IBlock) {
				parentBlock = (IBlock)parent;
			} else {
				parentBlock = getTestSuite().getImplementor().getBlock();
			}
			
			if (parentBlock != null) {
				for (Iterator i = selectionDialog.getTests().iterator(); i.hasNext();)
				{
					ITest test = (ITest)i.next();
					ResourceSet resourceSet = ((EObject)getTestSuite()).eResource().getResourceSet();
					ITest resourcetest = (ITest)EMFUtil.getEObject(resourceSet, (EObject)test, true);
					if (resourcetest == null) { // if not in resourceset, add it
						resourcetest = test;
						resourceSet.getResources().add(((EObject)test).eResource());
					}
					ITestInvocation testInvocation = HyadesFactory.INSTANCE.createTestInvocation(resourcetest);
					testInvocation.setName(calculateName(resourcetest));
					
					parentBlock.getActions().add(testInvocation);
				}
			}
			setActionPerformed(true);
		}
	}
	
	abstract protected InvokedTestSelectionDialog createInvokedTestSelectionDialog(ITestSuite testSuite);
	
	protected String calculateName(ITest test)
	{
		String testName = test.getName();
		if(testName == null)
			return TestCommonUtil.getUniqueName(getBaseName(), getBlock().getActions());
			
		if(test instanceof ITestCase)
		{
			ITestSuite invokedTestSuite = ((ITestCase)test).getOwner();
			if(getTestSuite() != invokedTestSuite)
			{ 
				String testSuiteName = invokedTestSuite.getName();
				if(testSuiteName != null)
					testName = testSuiteName + "." + testName; //$NON-NLS-1$
			} 
		}
		
		return ((testName.concat(" - ").concat(getBaseName()))); 
	}
}
