/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestCaseNewWizard.java,v 1.9 2009/10/23 18:15:18 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.common.internal.wizard;

import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.models.common.util.SaveManager;
import org.eclipse.hyades.test.tools.core.common.util.TestCommonUtil;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.util.TestUIUtil;
import org.eclipse.hyades.test.ui.wizard.ITestCaseWizard;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;
import org.eclipse.hyades.ui.internal.wizard.NameAndDescriptionWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;

/**
 * <p>Wizard for test cases.</p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul Slauenwhite
 * @version	October 23, 2009
 * @since   January 2, 2005
 */
abstract public class TestCaseNewWizard extends HyadesWizard implements ITestCaseWizard {
    private NameAndDescriptionWizardPage nameAndDescriptionWizardPage;
    private ITestSuite testSuite;

    /**
     * Constructor for TestCaseNewWizard
     */
    public TestCaseNewWizard() {
        super();
        this.testSuite = null;
    }

    abstract protected String getType();

    /**
     * Returns the "name and description page" used by this wizard.
     * 
     * @return NameDescriptionWizardPage
     */
    protected NameAndDescriptionWizardPage getNameAndDescriptionWizardPage() {
        return nameAndDescriptionWizardPage;
    }

    /**
     * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
     */
    protected void initPages() {
        nameAndDescriptionWizardPage = new NameAndDescriptionWizardPage("nameDescription"); //$NON-NLS-1$
    }

    /**
     * @see org.eclipse.jface.wizard.IWizard#performFinish()
     */
    public boolean performFinish() {
        ITestSuite ts = getTestSuite();
        if (ts != null) {
			boolean isExternalBehavior = ts.getImplementor().isExternalImplementor();
            ITestCase testCase = TestCommonUtil.createTestCase(ts, getType(), isExternalBehavior, getNameAndDescriptionWizardPage().getItemName());
            testCase.setDescription(getNameAndDescriptionWizardPage().getItemDescription());
            SaveManager.saveResource((TPFTestSuite) ts);
            
            //Attempt to open the editor:
			TestUIUtil.openEditor(((TPFTestSuite)(ts)), TestUIExtension.GENERIC_TEST_SUITE_EDITOR_PART_ID);

            return true;
        }

        openErrorMessage(ToolsUiPluginResourceBundle.word_Error); 
        return false;
    }

    private void openErrorMessage(String message) {
        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), SWT.ICON_ERROR | SWT.OK | SWT.SYSTEM_MODAL);
        messageBox.setText(ToolsUiPluginResourceBundle.error_NullTestSuite); 
        messageBox.setMessage(message);
        messageBox.open();
    }

    /*
     * @see org.eclipse.hyades.test.ui.wizard.ITestCaseWizard#setTestSuite(org.eclipse.hyades.models.common.facades.behavioral.ITestSuite)
     */
    public void setTestSuite(ITestSuite ts) {
        this.testSuite = ts;
    }

    /**
     * @return Returns the testSuite.
     */
    public ITestSuite getTestSuite() {
        return this.testSuite;
    }
}
