/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TestHttpImages.java,v 1.6 2010/05/25 13:56:10 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http;

import java.net.URL;

import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.ui.internal.util.ImageManager;

/**
 * <p>Test HTTP image manager.</p>
 * 
 * <p><b>Note:</b>This class is not intended to be extended 
 * or used externally, and images are subject to be changed 
 * without notice.</p>
 * 
 * 
 * @author  Marcelo Patmarcelop
 * @author  Paul Slauenwhite
 * @version May 25, 2010
 * @since   February 2,2005
 */
public class TestHttpImages
extends ImageManager
{
	/**
	 * TestHttpImages' singleton.
	 */
	public static final TestHttpImages INSTANCE = new TestHttpImages();

	/**
	 * No-argument constructor.
	 */
	public TestHttpImages(){
		
		try	{
			initialize(new URL(ToolsUiPlugin.getDefault().getBundle().getEntry("/"), "icons/full/"), ToolsUiPlugin.getDefault().getImageRegistry()); //$NON-NLS-1$ //$NON-NLS-2$
		}
		catch(Exception e) {
			ToolsUiPlugin.logError(e);
		}	
	}
	
	/*
	 * Available cached Images in the HTTP plugin image registry.
	 */
	public static final String IMG_WIZBAN_NEW_HTTP_TESTSUITE 		= "http_newhsuite_wiz.gif";
	public static final String IMG_WIZBAN_NEW_HTTP_TESTCASE 		= "http_newtest_wiz.gif";
	
	public static final String IMG_HTTP_TEST_SUITE 					= "http_hsuite.gif";
	public static final String IMG_HTTP_TEST_CASE 				    = "http_request.gif";

	/**
	 * @deprecated As of TPTP 4.7.0, this image is deprecated.
	 */
	public static final String IMG_CHECK		 				    = "http_check.gif";
	
	/**
	 * @see org.eclipse.hyades.ui.util.ImageManager#addImages()
	 */
	protected void addImages()
	{
		add(T_WIZBAN, IMG_WIZBAN_NEW_HTTP_TESTSUITE);
		add(T_WIZBAN, IMG_WIZBAN_NEW_HTTP_TESTCASE);

		add(T_OBJ, IMG_HTTP_TEST_SUITE);
		add(T_OBJ, IMG_HTTP_TEST_CASE);
		add(T_OBJ, IMG_CHECK);
	}	
}
