/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpGenerator.java,v 1.15 2009/05/04 14:37:13 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.codegen;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.test.core.internal.changes.CreateFileChange;
import org.eclipse.hyades.test.tools.core.CorePlugin;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.DelegateProjectDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Helper;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.IProjectDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.JavaGenerator;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;

/**
 * <p>HttpGenerator.java</p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul Slauenwhite
 * @version May 4, 2009
 * @since   Februrary 1, 2005
 */
public class HttpGenerator extends JavaGenerator {
	
	public final static String PLUGIN_ID_JUNIT = "org.junit"; //$NON-NLS-1$
	public final static String PLUGIN_ID_EXECUTION_CORE = "org.eclipse.hyades.execution.core"; //$NON-NLS-1$
	public final static String PLUGIN_ID_EXECUTION_REMOTE = "org.eclipse.hyades.execution.remote"; //$NON-NLS-1$

	public HttpGenerator(ITestSuite testSuite, IProjectDependencyUpdater updater) {
		super(testSuite, new HttpProjectDependencyUpdater(updater));
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.tools.core.internal.common.codegen.Generator#createGenerateCodeChange(org.eclipse.core.resources.IFile, org.eclipse.core.runtime.IProgressMonitor)
	 */
	protected Change createGenerateCodeChange(IFile file, IProgressMonitor monitor) throws CoreException {
		
		Helper helper = new Helper();
		
		try {
			
			GenTestSuite genTestSuite = new GenTestSuite();
			
			computeTestMethodNames(getTestSuite(), false, helper);
			
			String generatedCode = Helper.formatContent(genTestSuite.generate(getTestSuite(), helper));			
			Change fileChange = new CreateFileChange(file, generatedCode, CHARSET_UTF8);
			Change methodNameChange = helper.getMethodNamesChange();
			
			if (methodNameChange != null) {
				
				CompositeChange compositeChange = new CompositeChange("Composite source refactoring"); //$NON-NLS-1$
				compositeChange.add(fileChange);
				compositeChange.add(methodNameChange);
				compositeChange.markAsSynthetic();
				
				return compositeChange;
			}
			
			return fileChange;
		} 
		finally {
			helper.dispose();
		}
	}

	static class HttpProjectDependencyUpdater extends DelegateProjectDependencyUpdater {

		public HttpProjectDependencyUpdater(IProjectDependencyUpdater delegate) {
			super(delegate);
			addRequiredPlugin(PLUGIN_ID_JUNIT, null);
			addRequiredPlugin(CorePlugin.getID(), "common.runner.jar"); //$NON-NLS-1$
			addRequiredPlugin(CorePlugin.getID(), "http.runner.jar"); //$NON-NLS-1$
			//add additional libraries in order to run as a JUnit - bugzilla_98741  jn
			addRequiredPlugin("org.eclipse.hyades.logging.core", null); //$NON-NLS-1$
			// add 2 additional logging libraries (tlcore, hlcbe101) so can run as a JUnit bugzilla_176437 mdd 
			addRequiredPlugin("org.eclipse.tptp.platform.logging.events", "tlcore.jar"); //$NON-NLS-1$
			addRequiredPlugin("org.eclipse.tptp.platform.logging.events", "hlcbe101.jar"); //$NON-NLS-1$
			addRequiredPlugin("org.eclipse.emf.ecore", null); //$NON-NLS-1$
			addRequiredPlugin("org.eclipse.emf.common", null); //$NON-NLS-1$
		}
		
	}

}
