/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpBehaviorForm.java,v 1.7 2007/04/20 17:40:46 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.junit.editor;

import org.eclipse.hyades.test.tools.ui.common.internal.editor.BehaviorSection;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.editor.JUnitBehaviorForm;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class HttpBehaviorForm
extends JUnitBehaviorForm
{
	/**
	 * Constructor for HttpBehaviorForm
	 * @param httpEditorExtension
	 * @param widgetFactory
	 */
	public HttpBehaviorForm(HttpEditorExtension httpEditorExtension, WidgetFactory widgetFactory)
	{
		super(httpEditorExtension, widgetFactory);
		setHeadingText(ToolsUiPluginResourceBundle.URL_EDT_GENERAL_INFO);
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.BehaviorForm#createBehaviorSection()
	 */
	protected BehaviorSection createBehaviorSection()
	{
		return new HttpBehaviorSection(this);
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_NAMED_ELEMENT_CONTROL:
				break;
				
			case HELP_FORM_CONTROL:
				break;
				
			case HELP_SECTION_CONTROL:
				break;
		}
	}	
}
