/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpEditorExtension.java,v 1.5 2007/03/22 14:42:45 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.junit.editor;

import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestSuiteEditorExtension;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;
import org.eclipse.hyades.ui.editor.IHyadesEditorPart;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class HttpEditorExtension 
extends TestSuiteEditorExtension
{
	public static final String EXTENSION_ID = "org.eclipse.hyades.test.http.internal.junit.editor.HttpEditorExtension";

	/**
	 * @see org.eclipse.hyades.ui.editor.IEditorExtension#createPages()
	 */
	public void createPages()
	{
		IHyadesEditorPart hyadesEditorPart = getHyadesEditorPart();
		WidgetFactory widgetFactory = new WidgetFactory();
		
		setTestSuiteForm(new HttpForm(this, widgetFactory));
		getTestSuiteForm().setTestCasePageIndex(PAGE_TEST_CASES);
		hyadesEditorPart.addPage(getTestSuiteForm().createControl());
		hyadesEditorPart.setPageText(PAGE_OVERVIEW, ToolsUiPluginResourceBundle.W_OVERVIEW);

		setTestCasesForm(new HttpTestCasesForm(this, widgetFactory));
		hyadesEditorPart.addPage(getTestCasesForm().createControl());
		hyadesEditorPart.setPageText(PAGE_TEST_CASES, ToolsUiPluginResourceBundle.W_REQUESTS);
		
		setBehaviorForm(new HttpBehaviorForm(this, widgetFactory));
		hyadesEditorPart.addPage(getBehaviorForm().createControl());
		hyadesEditorPart.setPageText(PAGE_BEHAVIOR, UiPluginResourceBundle.W_BEHAVIOR);
		
		getTestSuiteForm().updateTitle();
	}
}