/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpForm.java,v 1.10 2007/04/26 20:23:32 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.junit.editor;

import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.editor.JUnitForm;
import org.eclipse.hyades.test.ui.editor.form.util.NamedElementsSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * @author marcelop
 * @since 1.0.2
 */
public class HttpForm 
extends JUnitForm
{
	
	private UserSection userSection;
	
	/**
	 * Constructor for HttpForm
	 * @param httpEditorExtension
	 * @param widgetFactory
	 */
	public HttpForm(HttpEditorExtension httpEditorExtension, WidgetFactory widgetFactory)
	{
		super(httpEditorExtension, widgetFactory);
		setHeadingText(ToolsUiPluginResourceBundle.URL_EDT_GENERAL_INFO);
	}


	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_FORM_CONTROL:
				break;
				
			case HELP_TEST_CASE_CONTROL:
				break;
				
			case HELP_TYPE_CONTROL:
				break;

			case HELP_FILE_CASE_CONTROL:
				break;
		}
	}
	
	protected void createLeftColumnControls(Composite parent)
	{
		Control control = createGenericInformation(parent, ToolsUiPluginResourceBundle.URL_EDT_GENERAL_INFO, ToolsUiPluginResourceBundle.URL_EDT_GENERAL_DSC);
		control.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING));
		registerHelp(HELP_FORM_CONTROL, control);
		
		createSourceInfoSection(parent);
	}
	
	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestSuiteForm#createTestCaseElementsSectionControl(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.util.NamedElementsSection)
	 */
	protected Control createTestCaseElementsSectionControl(Composite parent, NamedElementsSection testCaseElementsSection)
	{
		return testCaseElementsSection.createControl(parent, factory, ToolsUiPluginResourceBundle.W_REQUESTS, ToolsUiPluginResourceBundle.EDT_REQUEST_DSC);
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.tools.ui.common.internal.editor.TestSuiteForm#createRightColumnControls(org.eclipse.swt.widgets.Composite)
	 */
	protected void createRightColumnControls(Composite parent) {
		// Add the User section
		userSection = new UserSection(this);
		userSection.setHeaderText(ToolsUiPluginResourceBundle.HttpForm_DEPLOYMENT);
		userSection.setCollapsable(true);
		registerSection(userSection);
		Control control = userSection.createControl(parent, getFactory());
		control.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.VERTICAL_ALIGN_BEGINNING));
		//registerHelp(---, control);
		super.createRightColumnControls(parent);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.editor.form.util.EditorForm#load()
	 */
	public void load() {
		userSection.setInput(getTestSuite());
		super.load();
	}
	
}
