/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpTestCasesForm.java,v 1.17 2010/05/14 16:44:34 paules Exp $
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.junit.editor;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.hyades.models.common.facades.behavioral.ITestCase;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.test.tools.core.common.TestCommon;
import org.eclipse.hyades.test.tools.core.http.util.HttpConstants;
import org.eclipse.hyades.test.tools.core.http.util.RequestHelper;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.TestCasesForm;
import org.eclipse.hyades.test.tools.ui.common.internal.editor.action.AddTestCase;
import org.eclipse.hyades.test.tools.ui.http.internal.preferences.HttpPreferenceUtil;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.actions.OpenTestMethodAction;
import org.eclipse.hyades.test.ui.editor.form.util.ExtensibleEObjectTreeSection;
import org.eclipse.hyades.test.ui.editor.form.util.IDetailPage;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection;
import org.eclipse.hyades.test.ui.internal.editor.form.util.StaticDetailPageProvider;
import org.eclipse.hyades.test.ui.internal.editor.form.util.TreeSection;
import org.eclipse.hyades.test.ui.internal.model.ui.ChildrenSelectionAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenDownAction;
import org.eclipse.hyades.test.ui.internal.model.ui.MoveChildrenUpAction;
import org.eclipse.hyades.test.ui.internal.model.ui.RemoveChildrenAction;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/**
 * <p>HttpTestCasesForm.java</p>
 * 
 * 
 * @author  Marcelo Paternostro
 * @author  Paul Slauenwhite
 * @version May 14, 2010
 * @since   Februrary 1, 2005
 */
public class HttpTestCasesForm extends TestCasesForm{
	
	private StaticDetailPageProvider detailPageProvider;

	/**
	 * Constructor for HttpTestCasesForm
	 * @param httpEditorExtension
	 * @param widgetFactory
	 */
	public HttpTestCasesForm(HttpEditorExtension httpEditorExtension, WidgetFactory widgetFactory)
	{
		super(httpEditorExtension, widgetFactory);
		setHeadingText(ToolsUiPluginResourceBundle.URL_EDT_GENERAL_INFO); 
	}

	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#createLeftColumn(org.eclipse.swt.widgets.Composite)
	 */
	protected void createLeftColumn(Composite parent)
	{
		createTestCaseSection(parent);
		createNamedElementSection(parent);
	}

	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#createRightColumn(org.eclipse.swt.widgets.Composite)
	 */
	protected void createRightColumn(Composite parent)
	{
		createDetailSection(parent);
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.TestCasesForm#getAddTestCaseAction()
	 */
	protected IAction getAddTestCaseAction()
	{
		return new AddTestCase(this, TestCommon.HTTP_JUNIT_TEST_CASE_TYPE, ToolsUiPluginResourceBundle.W_HTTP_REQUEST.toLowerCase()) 
		{
			protected void adjusTestCase(ITestCase testCase)
			{
				RequestHelper requestHelper = new RequestHelper();
				requestHelper.setTestCase(testCase);
				requestHelper.setAttribute(RequestHelper.ATT_HOST, HttpPreferenceUtil.getInstance().getDefaultHostName());
				requestHelper.setAttribute(RequestHelper.ATT_PORT, HttpPreferenceUtil.getInstance().getDefaultHostPort());
				requestHelper.setAttribute(RequestHelper.ATT_ABS_PATH, HttpPreferenceUtil.getInstance().getDefaultAbsolutePath());
				requestHelper.setAttribute(RequestHelper.ATT_METHOD, HttpConstants.SUPPORTED_REQUEST_METHODS[0]);
				requestHelper.setAttribute(RequestHelper.ATT_VERSION, HttpConstants.HTTP_VERSION);
				requestHelper.setAttribute(RequestHelper.ATT_THINK_TIME, HttpPreferenceUtil.getInstance().getDefaultThinkTime());

				// TODO: JC> Find something equivalent to the following line
				//detailSection.setInput(testCase);
			}
		};
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.TestCasesForm#getTestCasesSectionHeaderText()
	 */
	protected String getTestCasesSectionHeaderText()
	{
		return ToolsUiPluginResourceBundle.W_REQUESTS; 
	}

	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_NAMED_ELEMENT_CONTROL:
				break;

			case HELP_TEST_CASES_SECTION_CONTROL:
				break;

			case HELP_TEST_CASES_SECTION_TREE_CONTROL:
				break;
		}
	}

	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#addDetails(org.eclipse.hyades.test.ui.internal.editor.form.util.DetailSection)
	 */
	protected void addDetails(StaticDetailPageProvider detailPageProvider)
	{
		this.detailPageProvider = detailPageProvider;
		detailPageProvider.addDetailPage(ITestCase.class, new HttpTestCaseDetailPage());
	}
	
	/*
	 *  (non-Javadoc)
	 * @see org.eclipse.hyades.test.tools.ui.common.internal.editor.TestCasesForm#createDetailSection(org.eclipse.swt.widgets.Composite)
	 */
	protected void createDetailSection(Composite parent) {
		super.createDetailSection(parent);
		DetailSection detailSection = getDetailSection();
		if(detailSection!= null && detailPageProvider != null)
		{
			IDetailPage detailPage = detailPageProvider.getDetailPage(ITestCase.class);
			Composite client = detailSection.getClient();
			Control pageControl = detailPage.createControl(client, getWidgetFactory(), detailSection);
			pageControl.setLayoutData(GridDataUtil.createFill());
			getDetailSection().addControlWithDetailPage(detailPage, pageControl);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.tools.ui.common.internal.editor.TestCasesForm#createTestCasesSection()
	 */
	protected TreeSection createTestCasesSection(){
		
		IAction[] actions = new IAction[] {
				getAddTestCaseAction(),
				new RemoveChildrenAction(false),
				new MoveChildrenUpAction(),
				new MoveChildrenDownAction(),
				new OpenTestMethodAction(),
				new CheckTestCaseAction()
		};

		EStructuralFeature feature = Common_TestprofilePackage.eINSTANCE.getTPFTestSuite_TestCases();
		((MoveChildrenUpAction)(actions[2])).setEStructuralFeature(feature);
		((MoveChildrenDownAction)(actions[3])).setEStructuralFeature(feature);

		ExtensibleEObjectTreeSection section = new ExtensibleEObjectTreeSection(this, feature, actions);			
		section.setEditable(true);
		
		for (int counter = 0; counter < actions.length; counter++) {
			
			if (actions[counter] instanceof ChildrenSelectionAction) {
				((ChildrenSelectionAction)(actions[counter])).setStructuredViewer(section.getTreeViewer());
			}
		}
		
		return section;
	}
}
