/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: UserSection.java,v 1.8 2010/03/03 14:06:40 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.junit.editor;

import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.ui.editor.form.util.EditorForm;
import org.eclipse.hyades.test.ui.editor.form.util.EditorSection;
import org.eclipse.hyades.test.ui.editor.form.util.WidgetFactory;
import org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

/**
 * <p>UserSection.java</p>
 * 
 * 
 * @author  Julien Canches
 * @author  Paul E. Slauenwhite
 * @version March 3, 2010
 * @since   March 18, 2005
 */
public class UserSection extends EditorSection implements ModifyListener {
	
	private StyledText usersText;
	private CFGInstance instance;
	
	/**
	 * @param editorForm
	 */
	public UserSection(EditorForm editorForm) {
		super(editorForm);
	}
	
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.internal.editor.form.base.FormSection#createClient(org.eclipse.swt.widgets.Composite, org.eclipse.hyades.test.ui.internal.editor.form.base.FormWidgetFactory)
	 */
	public Composite createClient(Composite parent, FormWidgetFactory factory) {
		WidgetFactory widgetFactory = getEditorForm().getWidgetFactory();
		Composite composite = factory.createComposite(parent);			
		composite.setLayout(new GridLayout());
		composite.setLayoutData(GridDataUtil.createFill());
				
		factory.createLabel(composite, ToolsUiPluginResourceBundle.UserSection_USERS);

		usersText = widgetFactory.createStyledText(composite, SWT.FULL_SELECTION | SWT.SINGLE,
				stripAmps(ToolsUiPluginResourceBundle.UserSection_USERS));
		usersText.setLayoutData(GridDataUtil.createHorizontalFill());
		usersText.setEditable(false);
		usersText.addVerifyKeyListener(this);
		
		widgetFactory.paintBordersFor(composite);
		return composite;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.editor.form.util.EditorSection#setInput(java.lang.Object)
	 */
	public void setInput(Object object) {
		if(object instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection)object;
			if(structuredSelection.size() == 1)
				object = structuredSelection.getFirstElement();
		}
		
		if(object instanceof TPFTestSuite && ((TPFTestSuite)object).getInstances().size() > 0) {
			instance = (CFGInstance) ((TPFTestSuite)object).getInstances().get(0);
			adjustTexts();
			usersText.setEditable(true);
		} else {
			instance = null;
			usersText.setText("");
			usersText.setEditable(false);
		}
	}
	
	protected void adjustTexts() {
		usersText.removeModifyListener(this);
		//bugzilla_90127 jmn - do not show users < 1.
		usersText.setText(Integer.toString(Math.max(1,instance.getMaxCount())));		
		usersText.addModifyListener(this);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.editor.form.util.EditorSection#getInput()
	 */
	public Object getInput() {
		return instance;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.test.ui.editor.form.util.EditorSection#getStructuredSelection()
	 */
	public IStructuredSelection getStructuredSelection() {
		if(instance == null)
			return StructuredSelection.EMPTY;
		return new StructuredSelection(instance);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.part.ISetSelectionTarget#selectReveal(org.eclipse.jface.viewers.ISelection)
	 */
	public void selectReveal(ISelection selection) {
		// NOP
	}

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.ModifyListener#modifyText(org.eclipse.swt.events.ModifyEvent)
	 */
	public void modifyText(ModifyEvent e) {
		if (e.widget == usersText) {
			if (instance != null) {
				try {
					int value = Integer.parseInt(usersText.getText());
					if (value > 0) {
						instance.setMaxCount(value);
					}
				} catch (NumberFormatException exc) {
					// Don't do anything
				}
			}
		}
	}
	
	private String stripAmps(String str)
	{
		return str.replaceAll("&", "");
		
	}

}
