/********************************************************************** 
 * Copyright (c) 2009, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: HTTPTestCaseProxyNode.java,v 1.2 2010/10/25 12:31:06 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.tools.ui.http.internal.junit.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.test.tools.ui.java.JavaSourceTestCaseProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestCaseProxyNode;
import org.eclipse.ui.IMemento;

/**
 * <p>HTTP test case proxy node to specialize the actions in the context menu 
 * of the Test Navigator.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author  Jerome Bozier
 * @version	October 25, 2010
 * @since 	May 4, 2009
 * @see     HTTPTestProxyFactory
 */
public class HTTPTestCaseProxyNode extends JavaSourceTestCaseProxyNode implements ITestCaseProxyNode {

    public HTTPTestCaseProxyNode(TPFTestCase testCase, Object parent) {
        super(testCase, parent);
    }
    
    public HTTPTestCaseProxyNode(IMemento memento, Object parent) {
        super(memento, parent);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.internal.navigator.proxy.DefaultTestCaseProxyNode#getFactoryID()
     */
    public String getFactoryID() {
        return "org.eclipse.hyades.test.tools.ui.HTTPTestSuiteFactory"; //$NON-NLS-1$
    }
}
