/********************************************************************** 
 * Copyright (c) 2009 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: HTTPTestProxyFactory.java,v 1.1 2009/05/04 14:37:13 paules Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.tools.ui.http.internal.junit.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIConstants;
import org.eclipse.hyades.test.ui.navigator.DefaultTypedElementProxyFactory;
import org.eclipse.hyades.test.ui.navigator.IProxyNode;
import org.eclipse.ui.IMemento;

/**
 * <p>This factory is responsible to create special proxy nodes for HTTP Unit test suites and cases.</p>
 * 
 * <p>Those test suites should have the type <code>org.eclipse.hyades.test.http.junit.testSuite</code>.</p>
 * 
 * <p>Those test cases should have the type <code>org.eclipse.hyades.test.http.junit.testCase</code>.</p>
 *
 * 
 * @author  Paul E. Slauenwhite
 * @version May 4, 2009
 * @since   May 4, 2009
 * @see     HTTPTestSuiteProxyNode
 * @see     HTTPTestCaseProxyNode
 */
public class HTTPTestProxyFactory extends DefaultTypedElementProxyFactory {

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.navigator.ITypedElementProxyFactory#create(org.eclipse.hyades.models.common.testprofile.TPFTest, java.lang.Object)
     */
    public IProxyNode create(TPFTest test, Object parent) {
        
    	if (test instanceof TPFTestSuite) {
            return (new HTTPTestSuiteProxyNode(((TPFTestSuite)(test)), parent));
        }
        else if (test instanceof TPFTestCase) {
            return (new HTTPTestCaseProxyNode(((TPFTestCase)(test)), parent));
        }

        return (super.create(test, parent));
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.navigator.IPersistableTypedElementProxyFactory#recreate(org.eclipse.ui.IMemento, java.lang.Object)
     */
    public IProxyNode recreate(IMemento memento, Object parent) {
        
    	String nodeKind = memento.getString(TestUIConstants.TAG_NODE_KIND);
        
    	if(nodeKind.equals(TestUIConstants.TESTSUITE_NODE)) {
            return (new HTTPTestSuiteProxyNode(memento, parent));
        } 
        else if(nodeKind.equals(TestUIConstants.TESTCASE_NODE)) {
            return (new HTTPTestCaseProxyNode(memento, parent));
        } 
        else {
            return (super.recreate(memento, parent));
        }
    }
}
