/********************************************************************** 
 * Copyright (c) 2009, 2010 IBM Corporation and others. 
 * All rights reserved.   This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * $Id: HTTPTestSuiteProxyNode.java,v 1.2 2010/10/25 12:31:06 bjerome Exp $ 
 * 
 * Contributors: 
 * IBM - Initial API and implementation 
 **********************************************************************/ 
package org.eclipse.hyades.test.tools.ui.http.internal.junit.navigator;

import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.tools.ui.java.JavaSourceTestSuiteProxyNode;
import org.eclipse.hyades.test.ui.navigator.ITestSuiteProxyNode;
import org.eclipse.ui.IMemento;

/**
 * <p>HTTP test suite proxy node to specialize the actions in the context menu 
 * of the Test Navigator.</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @author 	Jerome Bozier
 * @version	October 25, 2010
 * @since 	May 4, 2009
 * @see     HTTPTestProxyFactory
 */
public class HTTPTestSuiteProxyNode extends JavaSourceTestSuiteProxyNode implements ITestSuiteProxyNode {

    public HTTPTestSuiteProxyNode(TPFTestSuite testSuite, Object parent) {
        super(testSuite, parent);
    }
    
    public HTTPTestSuiteProxyNode(IMemento memento, Object parent) {
        super(memento, parent);
    }
    
    /* (non-Javadoc)
     * @see org.eclipse.hyades.test.ui.navigator.IPersistableProxyNode#getFactoryID()
     */
    public String getFactoryID() {
        return "org.eclipse.hyades.test.tools.ui.HTTPTestSuiteFactory"; //$NON-NLS-1$
    }
}
