/**********************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpGenerateWizard.java,v 1.14 2009/03/27 17:10:35 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.junit.wizard;

import org.eclipse.hyades.test.tools.core.internal.common.codegen.AutomaticDependencyUpdater;
import org.eclipse.hyades.test.tools.core.internal.common.codegen.Generator;
import org.eclipse.hyades.test.tools.ui.http.internal.codegen.HttpGenerator;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.tools.ui.java.internal.junit.wizard.GenerateWizard;

/**
 * <p>HttpGenerateWizard.java</p>
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version March 27, 2009
 * @since   February 1, 2005
 */
public class HttpGenerateWizard extends GenerateWizard {
	
    public HttpGenerateWizard() {
        super();
        setWindowTitle(ToolsUiPluginResourceBundle.JAVA_GEN_WTITLE); 
    }
    
	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.wizard.GenerateWizard#createGenerator()
	 */
	protected Generator createGenerator()
	{
		return new HttpGenerator(getTestSuite(), new AutomaticDependencyUpdater());
	}
	
}