/*******************************************************************************
 * Copyright (c) 2005, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpTestCaseNewWizard.java,v 1.7 2009/03/27 17:10:35 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.junit.wizard;

import org.eclipse.hyades.test.tools.core.common.TestCommon;
import org.eclipse.hyades.test.tools.ui.common.internal.wizard.TestCaseNewWizard;
import org.eclipse.hyades.test.tools.ui.http.TestHttpImages;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.ui.internal.resources.UiPluginResourceBundle;

/**
 * <p>Wizard for the JUnit test case.</p>
 *  
 *
 * @author  Marcelo Paternostro
 * @author  Paul E. Slauenwhite
 * @version March 27, 2009
 * @since   February 1, 2005
 */
public class HttpTestCaseNewWizard
extends TestCaseNewWizard
{
	/**
	 * Constructor for TestCaseNewWizard
	 */
	public HttpTestCaseNewWizard()
	{
		super();

		setWindowTitle(ToolsUiPluginResourceBundle.WIZ_TST_CASE_TTL); 
		setDefaultPageImageDescriptor(TestHttpImages.INSTANCE.getImageDescriptor(TestHttpImages.IMG_WIZBAN_NEW_HTTP_TESTCASE));
	}

	/**
	 * Returns the type for the test case created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestCommon.HTTP_JUNIT_TEST_CASE_TYPE;
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages(){
		
        getNameAndDescriptionWizardPage().setTitle(ToolsUiPluginResourceBundle.WIZ_TST_CASE_TTL); 
        getNameAndDescriptionWizardPage().setDescription(UiPluginResourceBundle.WIZ_TST_CASE_GEN_PG_ATT_DSC); 
		
        addPage(getNameAndDescriptionWizardPage());
	}
}
