/*******************************************************************************
 * Copyright (c) 2005, 2010 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpTestSuiteNewWizard.java,v 1.12 2010/05/05 12:32:23 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.junit.wizard;

import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.facades.behavioral.ITestSuite;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.tools.core.common.TestCommon;
import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.http.TestHttpImages;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.test.ui.wizard.JavaTestLocationPage;
import org.eclipse.hyades.test.ui.wizard.TestSuiteNewWizard;
import org.eclipse.hyades.test.ui.wizard.TestSuiteNewWizard2;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;

/**
 * <p>Extension of the {@link TestSuiteNewWizard} wizard for creating URL test suites.</p>
 *
 * 
 * @author  Marcelo Paternostro
 * @author  Paul Slauenwhite
 * @version May 4, 2010
 * @since   February 1, 2005
 */
public class HttpTestSuiteNewWizard extends TestSuiteNewWizard2 {
    
	/**
     * Constructor for TestSuiteNewWizard
     */
    public HttpTestSuiteNewWizard() {
        super();
        setWindowTitle(ToolsUiPluginResourceBundle.WIZ_TST_HTTP_SUITE_TTL); 
        setDefaultPageImageDescriptor(TestHttpImages.INSTANCE.getImageDescriptor(TestHttpImages.IMG_WIZBAN_NEW_HTTP_TESTSUITE));

        IDialogSettings dialogSettings = ToolsUiPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = dialogSettings.getSection("HttpTestSuiteNewWizard"); //$NON-NLS-1$
        if (settings == null) settings = dialogSettings.addNewSection("HttpTestSuiteNewWizard"); //$NON-NLS-1$
        setDialogSettings(settings);
    }

    /**
     * Returns the type for the test suite created by this wizard.
     * @return String
     */
    protected String getType() {
        return TestCommon.HTTP_JUNIT_TEST_SUITE_TYPE;
    }

    /**
     * @see org.eclipse.jface.wizard.IWizard#addPages()
     */
    public void addPages() {
        super.addPages();

        getLocationPage().setTitle(ToolsUiPluginResourceBundle.WIZ_TST_HTTP_SUITE_TTL); 
        getLocationPage().setDescription(ToolsUiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_LOC_DSC); 

        getAttributeWizardPage().setTitle(ToolsUiPluginResourceBundle.WIZ_TST_HTTP_SUITE_TTL); 
        getAttributeWizardPage().setDescription(ToolsUiPluginResourceBundle.WIZ_TST_SUITE_GEN_PG_ATT_DSC); 
    }

    /**
     * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
     */
    protected void initPages() {
        
    	IStructuredSelection structuredSelection = adjustSeletion();

        JavaTestLocationPage locationPage = new JavaTestLocationPage("location", structuredSelection); //$NON-NLS-1$
        
        // Set the super.locationPage value
        setLocationPage(locationPage);

        String fileExtension = getFileExtension();
        if (fileExtension != null) {
            locationPage.setFileExtension(fileExtension);
            locationPage.setFileName(""); //$NON-NLS-1$
        }

        // Set the super.attributeWizardPage value
        setAttributeWizardPage(new AttributeWizardPage("nameDescription")); //$NON-NLS-1$
    }
    
	protected void adjustTestSuite(ITestSuite testSuite) {
		TPFTestSuite tpfTestSuite = (TPFTestSuite)testSuite;
		((CFGInstance)tpfTestSuite.getInstances().get(0)).setMaxCount(1);
	}
	
}