/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: RunInstancesPage.java,v 1.6 2007/05/03 01:33:34 paules Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.junit.wizard;

import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

/**
 * @author amathur
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class RunInstancesPage extends WizardPage implements Listener {

	private Text nusersText;
	private int nusers = 1;
	
	private static final int SIZING_TEXT_FIELD_WIDTH = 250;

	/**
	 * @param pageName
	 */
	public RunInstancesPage() {
		super("instances");
		setTitle(ToolsUiPluginResourceBundle.RUN_WTITLE);
		setDescription(ToolsUiPluginResourceBundle.RUN_IDESC);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
		Font font = parent.getFont();
		
		// resource name group
		Composite nameGroup = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginWidth = 0;
		nameGroup.setLayout(layout);
		nameGroup.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));
		nameGroup.setFont(font);

		Label label = new Label(nameGroup,SWT.NONE);
		label.setText(ToolsUiPluginResourceBundle.NUMBER_OF_USERS);
		label.setFont(font);

		// resource name entry field
		nusersText = new Text(nameGroup,SWT.BORDER);
		nusersText.addListener(SWT.Modify,this);
		GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL);
		data.widthHint = SIZING_TEXT_FIELD_WIDTH;
		nusersText.setLayoutData(data);
		nusersText.setFont(font);
		nusersText.setText(String.valueOf(nusers));

		setControl(nameGroup);
		setPageComplete(validatePage());
	}

	protected void addControl(Composite parent)
	{
	}

	/**
	 * @see org.eclipse.jface.dialogs.IDialogPage#setVisible(boolean)
	 */
	public void setVisible(boolean visible)
	{
		super.setVisible(visible);
		if(visible) {
			nusersText.setFocus();
			nusersText.selectAll();
		}
	}		
	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Listener#handleEvent(org.eclipse.swt.widgets.Event)
	 */
	public void handleEvent(Event event) {
		setPageComplete(validatePage());
	}
	
	protected boolean validatePage() {
		String number = nusersText.getText();
		
		try {
			Integer n = Integer.valueOf(number);
			if (n.intValue() < 0) {
				setErrorMessage(ToolsUiPluginResourceBundle.ENTER_POSITIVE_NUMBER);
				return false;
			}
			nusers = n.intValue();
			setErrorMessage(null);
			return true;
		}
		catch (NumberFormatException nfe) {
			setErrorMessage(ToolsUiPluginResourceBundle.ENTER_POSITIVE_NUMBER);
			return false;
		}
	}

	/**
	 * @return
	 */
	public int getNusers() {
		return nusers;
	}

	/**
	 * @param i
	 */
	public void setNusers(int i) {
		// Need to prevent setting the number of users to a positive number
		if (i < 1) {
			nusers = 1;
		}
		else {
			nusers = i;
		}
	}
}
