/**********************************************************************
 * Copyright (c) 2005, 2008 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: HttpPreferencePage.java,v 1.11 2008/03/06 18:36:46 paules Exp $
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.tools.ui.http.internal.preferences;

import org.eclipse.hyades.test.tools.ui.ToolsUiPlugin;
import org.eclipse.hyades.test.tools.ui.internal.resources.ToolsUiPluginResourceBundle;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * HTTP preference page.
 * 
 * 
 * @author  Paul E. Slauenwhite
 * @version March 6, 2008
 * @since   February 1, 2005
 */
public class HttpPreferencePage extends PreferencePage implements IWorkbenchPreferencePage
{
	
	private Text defaultHostNameText;
	private StyledText defaultHostPortText;
	private Text defaultAbsolutePathText;
	private StyledText defaultThinkTime;
	private StyledText	defaultVariance;
	

	/**
	 * Constructor for PluginPreferencePage.
	 */
	public HttpPreferencePage()
	{
		super();
	}

	/**
	 * Does anything necessary because the default button has been pressed.
	 */
	protected void performDefaults()
	{
		defaultHostNameText.setText(HttpPreferenceUtil.getInstance().getDefaultHostName(true));
		defaultHostPortText.setText(HttpPreferenceUtil.getInstance().getDefaultHostPort(true));
		defaultAbsolutePathText.setText(HttpPreferenceUtil.getInstance().getDefaultAbsolutePath(true));
		defaultThinkTime.setText( HttpPreferenceUtil.getInstance().getDefaultThinkTime( true ));
		defaultThinkTime.setText( HttpPreferenceUtil.getInstance().getDefaultVariance( true ));
	}

	protected void storeValues()
	{
		
		HttpPreferenceUtil.getInstance().setDefaultHostName(defaultHostNameText.getText());
		HttpPreferenceUtil.getInstance().setDefaultHostPort(defaultHostPortText.getText());
		HttpPreferenceUtil.getInstance().setDefaultAbsolutePath(defaultAbsolutePathText.getText());
		HttpPreferenceUtil.getInstance().setDefaultThinkTime( defaultThinkTime.getText() );
		HttpPreferenceUtil.getInstance().setDefaultVariance( defaultVariance.getText() );

		ToolsUiPlugin.getDefault().savePluginPreferences();
	}

	/**
	 * @see PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent)
	{
		//Un-comment when content is provided under defect #200586:
		//ToolsUiPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(parent, ToolsUiPlugin.getID() + ".ctst0011");
		
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout();
		GridData gridData;

		layout.marginWidth = 0;
		layout.marginHeight = 10;
		layout.numColumns = 1;
		composite.setLayout(layout);

		Group defaultGroup = new Group(composite, SWT.NONE);

		layout = new GridLayout();
		layout.marginWidth = 5;
		layout.marginHeight = 10;
		layout.numColumns = 4; // aberns

		defaultGroup.setLayout(layout);
		defaultGroup.setLayoutData(GridDataUtil.createHorizontalFill());

		defaultGroup.setText(ToolsUiPluginResourceBundle.control_default_Values);

		Label label = new Label(defaultGroup, SWT.NONE);
		label.setText(ToolsUiPluginResourceBundle.Host_Name_Label);
		defaultHostNameText = new Text(defaultGroup, SWT.BORDER);
		gridData = GridDataUtil.createHorizontalFill();
		gridData.horizontalSpan = 3;
		defaultHostNameText.setLayoutData( gridData );

		label = new Label(defaultGroup, SWT.NONE);
		label.setText(ToolsUiPluginResourceBundle.Port_Label);
		defaultHostPortText = new StyledText(defaultGroup, SWT.BORDER);
		gridData = GridDataUtil.createHorizontalFill();

		GC gc = new GC( defaultHostNameText );
		gc.setFont( defaultHostNameText.getFont() );
		FontMetrics fm = gc.getFontMetrics();
		int hint = Dialog.convertHeightInCharsToPixels( fm, 1 ) + 3;
		gc.dispose();

		gridData.heightHint = hint;
		gridData.horizontalSpan = 3;
		defaultHostPortText.setLayoutData(gridData);
		defaultHostPortText.addVerifyKeyListener(new VerifyKeyListener()
		{
			public void verifyKey(VerifyEvent event)
			{
				UIUtil.integerStyledTextVerifyKey(event);
			}
		});
		
		label = new Label(defaultGroup, SWT.NONE);
		label.setText(ToolsUiPluginResourceBundle.Abs_Path_Label);
		defaultAbsolutePathText = new Text(defaultGroup, SWT.BORDER);
		gridData = GridDataUtil.createHorizontalFill();
		gridData.horizontalSpan = 3;
		defaultAbsolutePathText.setLayoutData( gridData );

		// aberns -->
		label = new Label(defaultGroup, SWT.NONE);
		label.setText( ToolsUiPluginResourceBundle.Think_Time);
		defaultThinkTime = new StyledText(defaultGroup, SWT.BORDER);
		gridData = GridDataUtil.createHorizontalFill();
		gridData.heightHint = hint;
		defaultThinkTime.setLayoutData(gridData);
		defaultThinkTime.addVerifyKeyListener(new VerifyKeyListener()
		{
			public void verifyKey(VerifyEvent event)
			{
				UIUtil.integerStyledTextVerifyKey(event);
			}
		});
		label = new Label(defaultGroup, SWT.NONE);
		label.setText( ToolsUiPluginResourceBundle.Variance);
		defaultVariance = new StyledText( defaultGroup, SWT.BORDER | SWT.SINGLE );
		gridData = GridDataUtil.createHorizontalFill();
		defaultVariance.setLayoutData( gridData ); 
		defaultVariance.setTextLimit( 2 );
		defaultVariance.addVerifyKeyListener( new VerifyKeyListener()
		{
			public void verifyKey(VerifyEvent event)
			{
				UIUtil.integerStyledTextVerifyKey(event);
			}
		});
		
		// aberns --<


		loadSavedValues();
		
		Dialog.applyDialogFont( composite );

		return composite;
	}

	private void loadSavedValues()
	{
		defaultHostNameText.setText(HttpPreferenceUtil.getInstance().getDefaultHostName());
		defaultHostPortText.setText(HttpPreferenceUtil.getInstance().getDefaultHostPort());
		defaultAbsolutePathText.setText(HttpPreferenceUtil.getInstance().getDefaultAbsolutePath());
		defaultThinkTime.setText( HttpPreferenceUtil.getInstance().getDefaultThinkTime() );
		defaultVariance.setText( HttpPreferenceUtil.getInstance().getDefaultVariance() );
		
	}

	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk()
	{
		storeValues();
		
		return true;
	}

	/**
	 * @see IWorkbenchPreferencePage#init(IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}
	
}